/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.clients.api.healthcheck;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.clients.api.healthcheck.dto.EnvironmentStatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.MandatoryStatusesResponseDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.SystemStatusDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="StatusController", description="Status Controller")
public interface StatusControllerApi {
    @Operation(operationId="checkEnvironment", summary="checkEnvironment", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/{projectId}/{environmentId}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentStatusDto> checkEnvironment(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") String var1, @Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") String var2, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var3, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var4, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var5);

    @Operation(operationId="checkEnvironmentByNames", summary="checkEnvironmentByNames", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/byNames/{projectName}/{environmentName}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentStatusDto> checkEnvironmentByNames(@Parameter(name="projectName", description="projectName", required=true) @PathVariable(value="projectName") String var1, @Parameter(name="environmentName", description="environmentName", required=true) @PathVariable(value="environmentName") String var2, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var3, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var4, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var5);

    @Operation(operationId="checkEnvironmentByNamesAndSendNotifications", summary="checkEnvironmentByNamesAndSendNotifications", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/byNames/sentTo/{subscribers}/{projectName}/{environmentName}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentStatusDto> checkEnvironmentByNamesAndSendNotifications(@Parameter(name="projectName", description="projectName", required=true) @PathVariable(value="projectName") String var1, @Parameter(name="environmentName", description="environmentName", required=true) @PathVariable(value="environmentName") String var2, @Parameter(name="subscribers", description="subscribers", required=true) @PathVariable(value="subscribers") String var3, @Parameter(name="reportSubject", description="reportSubject") @Valid @RequestParam(value="reportSubject", required=false) String var4, @Parameter(name="fail", description="fail") @Valid @RequestParam(value="fail", required=false) Boolean var5, @Parameter(name="warn", description="warn") @Valid @RequestParam(value="warn", required=false) Boolean var6, @Parameter(name="pass", description="pass") @Valid @RequestParam(value="pass", required=false) Boolean var7, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var8, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var9, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var10);

    @Operation(operationId="checkEnvironmentWithSpecifiedSystems", summary="checkEnvironmentWithSpecifiedSystems", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/{projectId}/{environmentId}/{systemIds}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentStatusDto> checkEnvironmentWithSpecifiedSystems(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") String var1, @Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") String var2, @Parameter(name="systemIds", description="systemIds", required=true) @PathVariable(value="systemIds") String var3, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var4, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var5, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var6);

    @Operation(operationId="checkEnvironmentWithSpecifiedSystemsByNames", summary="checkEnvironmentWithSpecifiedSystemsByNames", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/byNames/{projectName}/{environmentName}/{systemNames}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentStatusDto> checkEnvironmentWithSpecifiedSystemsByNames(@Parameter(name="projectName", description="projectName", required=true) @PathVariable(value="projectName") String var1, @Parameter(name="environmentName", description="environmentName", required=true) @PathVariable(value="environmentName") String var2, @Parameter(name="systemNames", description="systemNames", required=true) @PathVariable(value="systemNames") String var3, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var4, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var5, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var6);

    @Operation(operationId="checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications", summary="checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/byNames/sentTo/{subscribers}/{projectName}/{environmentName}/{systemNames}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentStatusDto> checkEnvironmentWithSpecifiedSystemsByNamesAndSendNotifications(@Parameter(name="projectName", description="projectName", required=true) @PathVariable(value="projectName") String var1, @Parameter(name="environmentName", description="environmentName", required=true) @PathVariable(value="environmentName") String var2, @Parameter(name="systemNames", description="systemNames", required=true) @PathVariable(value="systemNames") String var3, @Parameter(name="subscribers", description="subscribers", required=true) @PathVariable(value="subscribers") String var4, @Parameter(name="reportSubject", description="reportSubject") @Valid @RequestParam(value="reportSubject", required=false) String var5, @Parameter(name="fail", description="fail") @Valid @RequestParam(value="fail", required=false) Boolean var6, @Parameter(name="warn", description="warn") @Valid @RequestParam(value="warn", required=false) Boolean var7, @Parameter(name="pass", description="pass") @Valid @RequestParam(value="pass", required=false) Boolean var8, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var9, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var10, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var11);

    @Operation(operationId="checkProject", summary="checkProject", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/timezones/{projectId}"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentStatusDto>> checkProject(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") String var1, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var2, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var3);

    @Operation(operationId="checkSystem", summary="checkSystem", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemStatusDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/system/{projectId}/{environmentId}/{systemId}"}, produces={"application/json"})
    public ResponseEntity<SystemStatusDto> checkSystem(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") String var1, @Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") String var2, @Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") String var3, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var4, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var5, @Parameter(name="onlyMandatory", description="status") @Valid @RequestParam(value="onlyMandatory", required=false) Boolean var6);

    @Operation(operationId="mandatoryCheckEnvironments", summary="mandatoryCheckEnvironments", tags={"status-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MandatoryStatusesResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/status/report/{projectId}/{environmentIds}/{executionRequestId}"}, produces={"application/json"})
    public ResponseEntity<MandatoryStatusesResponseDto> mandatoryCheckEnvironments(@Parameter(name="projectId", description="projectId", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="environmentIds", description="environmentIds", required=true) @PathVariable(value="environmentIds") List<UUID> var2, @Parameter(name="executionRequestId", description="executionRequestId", required=true) @PathVariable(value="executionRequestId") UUID var3, @Parameter(name="status", description="status") @Valid @RequestParam(value="status", required=false) Boolean var4, @Parameter(name="configuration", description="configuration") @Valid @RequestParam(value="configuration", required=false) Boolean var5);
}

