/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.config;

import java.util.UUID;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.environments.service.notification.EventNotificationService;
import org.qubership.atp.environments.service.notification.KafkaEventNotificationService;
import org.qubership.atp.environments.service.notification.ProjectEventKafkaListener;
import org.qubership.atp.environments.service.notification.ProjectEventListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
public class KafkaNotificationConfiguration {
    @Value(value="${kafka.environments.topic}")
    public String kafkaEnvironmentsProducerTopic;
    @Value(value="${kafka.systems.topic}")
    public String kafkaSystemsProducerTopic;
    @Value(value="${kafka.connections.topic}")
    private String kafkaConnectionProducerTopic;
    @Value(value="${kafka.enable:false}")
    private boolean kafkaEnable;

    @Bean
    public ProjectEventListener projectEventListener(ProjectService projectService) {
        if (this.kafkaEnable) {
            return new ProjectEventKafkaListener(projectService);
        }
        return event -> {};
    }

    @Bean
    public EventNotificationService environmentEventNotificationService(KafkaTemplate<UUID, String> kafkaTemplate) {
        if (this.kafkaEnable) {
            return new KafkaEventNotificationService(kafkaTemplate, this.kafkaEnvironmentsProducerTopic);
        }
        return environmentEvent -> {};
    }

    @Bean
    public EventNotificationService systemEventNotificationService(KafkaTemplate<UUID, String> kafkaTemplate) {
        if (this.kafkaEnable) {
            return new KafkaEventNotificationService(kafkaTemplate, this.kafkaSystemsProducerTopic);
        }
        return systemEvent -> {};
    }

    @Bean
    public EventNotificationService connectionEventNotificationService(KafkaTemplate<UUID, String> kafkaTemplate) {
        if (this.kafkaEnable) {
            return new KafkaEventNotificationService(kafkaTemplate, this.kafkaConnectionProducerTopic);
        }
        return systemEvent -> {};
    }
}

