/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.environments.model.impl.Context;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.service.direct.impl.MetricService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class ContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ContextInterceptor.class);
    private final ContextRepository repo;
    private final MetricService metricService;
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";

    @Autowired
    public ContextInterceptor(ContextRepository repo, MetricService metricService) {
        this.repo = repo;
        this.metricService = metricService;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (null != ip && !"".equals(ip.trim()) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader(X_FORWARDED_FOR);
        if (null != ip && !"".equals(ip.trim()) && !"unknown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        boolean isFull = request.getParameter("full") != null && request.getParameter("full").isEmpty() || Boolean.parseBoolean(request.getParameter("full"));
        String patternUuid = "[a-zA-Z0-9-,%20 ]+";
        String getPatternUrl = "/api(/v2)?/(projects|environments|tools|systems|connections|subscribers)/" + patternUuid + "(/)?(/systems|" + patternUuid + ")?(/update-versions|" + patternUuid + ")?(/byName|.*)?";
        String postPatternUrl = "/api(/v2)?/(projects|environments|tools|systems|connections|subscribers)/(search|filter)?";
        boolean matches = false;
        switch (request.getMethod()) {
            case "GET": {
                Pattern pattern = Pattern.compile(getPatternUrl);
                matches = pattern.matcher(request.getRequestURI()).matches();
                break;
            }
            case "POST": {
                Pattern pattern = Pattern.compile(postPatternUrl);
                matches = pattern.matcher(request.getRequestURI()).matches();
                break;
            }
        }
        String patternUrlDep = "/api/projects/" + patternUuid + "/environments";
        Pattern patternDep = Pattern.compile(patternUrlDep);
        boolean matchesDep = patternDep.matcher(request.getRequestURI()).matches();
        if (matches || matchesDep) {
            if (isFull && request.getRequestURI().matches(".*(projects).*")) {
                log.info("Endpoint projects/${id}?full used from this IP " + ContextInterceptor.getIpAddr(request));
            }
            this.repo.setContext(new Context(isFull));
        } else {
            this.repo.setContext(new Context(false));
        }
        this.metricService.requestToService(ContextInterceptor.getIpAddr(request), request.getRequestURI());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

