/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db;

import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLBaseListener;
import com.querydsl.sql.SQLExceptionTranslator;
import com.querydsl.sql.SQLListener;
import com.querydsl.sql.SQLListenerContext;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.spring.SpringConnectionProvider;
import com.querydsl.sql.spring.SpringExceptionTranslator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import org.qubership.atp.environments.errorhandling.connection.EnvironmentSqlConnectionCloseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class DbConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DbConfiguration.class);

    @Bean
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public com.querydsl.sql.Configuration querydslConfiguration(DataSource dataSource) {
        SQLTemplates templates = PostgreSQLTemplates.builder().build();
        com.querydsl.sql.Configuration configuration = new com.querydsl.sql.Configuration(templates);
        configuration.setExceptionTranslator((SQLExceptionTranslator)new SpringExceptionTranslator());
        configuration.addListener((SQLListener)new ConnectionClosedListener(dataSource));
        return configuration;
    }

    @Bean
    public SQLQueryFactory queryFactory(DataSource dataSource, com.querydsl.sql.Configuration configuration) {
        SpringConnectionProvider springConnectionProvider = new SpringConnectionProvider(dataSource);
        return new SQLQueryFactory(configuration, (Supplier)springConnectionProvider);
    }

    @Bean
    public LockProvider lockProvider(DataSource dataSource) {
        return new JdbcTemplateLockProvider(dataSource);
    }

    private static class ConnectionClosedListener
    extends SQLBaseListener {
        private final DataSource dataSource;

        public ConnectionClosedListener(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void end(SQLListenerContext context) {
            Connection connection = context.getConnection();
            if (connection != null && !DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource) && context.getData(AbstractSQLQuery.class.getName() + "#PARENT_CONTEXT") == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.error("Failed to close SQL connection", (Throwable)e);
                    throw new EnvironmentSqlConnectionCloseException();
                }
            }
        }
    }
}

