/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.changes.v1.encrypting;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.crypt.api.CryptoProvider;
import org.qubership.atp.crypt.provider.BouncyCastleProvider;
import org.qubership.atp.environments.errorhandling.connection.EnvironmentSqlConnectionParamEncryptException;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.service.direct.EncryptorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EncryptingCustomTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptingCustomTask.class);
    private final EncryptorService encryptor;
    private final ConnectionRepositoryImpl connectionRepository;
    private final CryptoProvider cryptoProvider = new BouncyCastleProvider();
    private final List<String> encryptValues = Arrays.asList("password", "passphrase", "key", "token", "credentials", "authentication");

    public EncryptingCustomTask(EncryptorService encryptor, ConnectionRepositoryImpl connectionRepository) {
        this.encryptor = encryptor;
        this.connectionRepository = connectionRepository;
    }

    public void execute() {
        LOGGER.info("Starting migration encrypting");
        Map<UUID, ConnectionParameters> templateMap = this.connectionRepository.getConnectionTemplates().stream().collect(Collectors.toMap(Identified::getId, Connection::getParameters));
        this.connectionRepository.getAll().stream().filter(connection -> connection.getSourceTemplateId() != null).forEach(connection -> {
            try {
                ConnectionParameters connectionParameters = connection.getParameters();
                for (Map.Entry parameter : connectionParameters.entrySet()) {
                    if (StringUtils.isEmpty(parameter.getValue()) || this.isEncrypted((String)parameter.getValue()) || !templateMap.containsKey(connection.getSourceTemplateId()) || !((ConnectionParameters)templateMap.get(connection.getSourceTemplateId())).containsKey(parameter.getKey()) || !this.encryptValues.stream().anyMatch(encryptValue -> ((String)parameter.getKey()).contains((CharSequence)encryptValue))) continue;
                    connectionParameters.put((Object)((String)parameter.getKey()), (Object)this.encryptor.encryptString(((String)parameter.getValue()).trim()));
                    this.connectionRepository.getUpdateParametersQuery(connection.getId(), connectionParameters).execute();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while encrypting parameters of SQL connection [id: {}, name: {}]", new Object[]{connection.getId(), connection.getName(), e});
                throw new EnvironmentSqlConnectionParamEncryptException();
            }
        });
        LOGGER.info("Migration encrypting finished");
    }

    public boolean isEncrypted(String value) {
        return this.cryptoProvider.isEncrypted(value);
    }
}

