/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.modification.afterbefore;

import java.util.UUID;
import org.aopalliance.intercept.MethodInvocation;
import org.qubership.atp.environments.db.modification.EntityTypeStrategy;
import org.qubership.atp.environments.db.modification.ModificationInterceptor;
import org.qubership.atp.environments.db.modification.afterbefore.TrackedMethodStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStrategy
implements TrackedMethodStrategy {
    private static Logger LOG = LoggerFactory.getLogger(DeleteStrategy.class);
    private final ModificationInterceptor interceptor;
    private final EntityTypeStrategy idsStrategy;

    public DeleteStrategy(ModificationInterceptor interceptor, EntityTypeStrategy idsStrategy) {
        this.interceptor = interceptor;
        this.idsStrategy = idsStrategy;
    }

    @Override
    public Object proceed(MethodInvocation invocation) throws Throwable {
        Runnable notify = null;
        try {
            UUID id = this.getFirst(invocation);
            notify = this.idsStrategy.prepareNotification(id, this.interceptor);
        }
        catch (Exception e) {
            LOG.error("Can not handle event for " + invocation.getMethod().getName(), (Throwable)e);
        }
        Object result = invocation.proceed();
        if (notify != null) {
            try {
                notify.run();
            }
            catch (Exception e) {
                LOG.error("Can not handle event for " + invocation.getMethod().getName(), (Throwable)e);
            }
        }
        return result;
    }
}

