/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.ei;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.atp.ei.ntt.impl.NttProjectConverter;
import org.qubership.atp.environments.ei.ServiceScopeEntities;
import org.qubership.atp.environments.ei.model.Environment;
import org.qubership.atp.environments.ei.model.PostmanEnvironment;
import org.qubership.atp.environments.ei.model.PostmanValue;
import org.qubership.atp.environments.enums.UserManagementEntities;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentsExportExecutor
implements ExportExecutor {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsExportExecutor.class);
    @Value(value="${spring.application.name}")
    private String implementationName;
    private final EnvironmentService environmentService;
    private final SystemCategoriesService systemCategoriesService;
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final Decryptor decryptor;
    private static final String POSTMAN_KEY_TEMPLATE = "ENV.%s.%s.%s";

    public void exportToFolder(ExportImportData exportData, Path workDir) throws ExportException {
        log.info("Start export by request {}", (Object)exportData);
        Set environmentsStringIds = exportData.getExportScope().getEntities().getOrDefault(ServiceScopeEntities.ENTITY_ENVIRONMENTS.getValue(), new HashSet());
        environmentsStringIds.addAll(exportData.getExportScope().getEntities().getOrDefault(ServiceScopeEntities.ENTITY_TA_TOOLS.getValue(), new HashSet()));
        Set<UUID> environmentsIds = environmentsStringIds.stream().map(UUID::fromString).collect(Collectors.toSet());
        switch (exportData.getFormat()) {
            case ATP: {
                this.defaultExportToFolder(workDir, environmentsIds);
                break;
            }
            case NTT: {
                this.defaultExportToFolder(workDir, environmentsIds);
                log.info("Converting to ntt project. Project id {}", (Object)exportData.getProjectId());
                this.convertToNttFormat(workDir);
                break;
            }
            case POSTMAN: {
                this.postmanExportToFolder(workDir, environmentsIds);
                break;
            }
            default: {
                log.error("Export data unformatted: {}", (Object)exportData.getFormat());
            }
        }
        log.info("Project {} was exported. Request {}", (Object)exportData.getProjectId(), (Object)exportData);
    }

    public void postmanExportToFolder(Path workDir, Set<UUID> environmentsIds) {
        List<org.qubership.atp.environments.model.Environment> environments = this.environmentService.getByIds(new ArrayList<UUID>(environmentsIds));
        environments.stream().filter(environment -> environment.getSystems() != null).forEach(env -> {
            PostmanEnvironment postmanEnvironment = new PostmanEnvironment(env.getId(), env.getName(), new ArrayList<PostmanValue>());
            List<PostmanValue> postmanValueList = postmanEnvironment.getValues();
            env.getSystems().stream().filter(system -> system.getConnections() != null).forEach(system -> system.getConnections().stream().filter(connection -> connection.getParameters() != null).forEach(connection -> connection.getParameters().forEach((key, value) -> {
                PostmanValue postmanValue = new PostmanValue();
                postmanValue.setKey(String.format(POSTMAN_KEY_TEMPLATE, system.getName(), connection.getName(), key));
                if (this.decryptor.isEncrypted(value)) {
                    postmanValue.setValue("");
                } else {
                    postmanValue.setValue((String)value);
                }
                postmanValueList.add(postmanValue);
            })));
            this.objectSaverToDiskService.writeAtpEntityToFile(env.getName() + "." + UserManagementEntities.ENVIRONMENT.name().toLowerCase(Locale.getDefault()), (Object)postmanEnvironment, UserManagementEntities.ENVIRONMENT.name().toLowerCase(Locale.getDefault()), workDir, true);
        });
    }

    public void defaultExportToFolder(Path workDir, Set<UUID> environmentsIds) {
        ModelMapper modelMapper = new ModelMapper();
        this.environmentService.getByIds(new ArrayList<UUID>(environmentsIds)).stream().filter(Objects::nonNull).map(modelEnv -> (Environment)modelMapper.map(modelEnv, Environment.class)).forEach(eiEnv -> {
            if (eiEnv.getSystems() != null) {
                eiEnv.getSystems().stream().filter(system -> system.getConnections() != null).forEach(system -> system.getConnections().stream().filter(connection -> connection.getParameters() != null).forEach(connection -> connection.getParameters().entrySet().stream().filter(pair -> this.decryptor.isEncrypted((String)pair.getValue())).forEach(pair -> connection.getParameters().put((String)pair.getKey(), ""))));
            }
            this.objectSaverToDiskService.exportAtpEntity(eiEnv.getId(), eiEnv, workDir);
        });
    }

    private void convertToNttFormat(Path workDir) throws ExportException {
        HashMap categoryMap = new HashMap();
        List<SystemCategory> allCategories = this.systemCategoriesService.getAll();
        allCategories.forEach(systemCategory -> categoryMap.put(systemCategory.getId(), systemCategory.getName()));
        log.info("Starting to convert to ntt using export source dir {}", (Object)workDir);
        try {
            new NttProjectConverter(workDir).convertEnvironment(categoryMap).saveToFolder(workDir);
        }
        catch (Exception e) {
            ExportException.throwException((String)"Cannot convert export to NTT format. Source {}", (Object[])new Object[]{workDir, e});
        }
    }

    public String getExportImplementationName() {
        return this.implementationName;
    }

    public EnvironmentsExportExecutor(EnvironmentService environmentService, SystemCategoriesService systemCategoriesService, ObjectSaverToDiskService objectSaverToDiskService, Decryptor decryptor) {
        this.environmentService = environmentService;
        this.systemCategoriesService = systemCategoriesService;
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.decryptor = decryptor;
    }
}

