/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.qubership.atp.environments.mapper.AbstractMapper;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.Named;
import org.qubership.atp.environments.service.direct.IdentifiedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractVersioningMapper<S, D>
extends AbstractMapper<S, D> {
    private static final Logger log = LoggerFactory.getLogger(AbstractVersioningMapper.class);
    private static final String UNDEFINED = "Undefined name";

    public AbstractVersioningMapper(Class<S> sourceClass, Class<D> destinationClass) {
        super(sourceClass, destinationClass);
    }

    @PostConstruct
    public void init() {
        this.mapper.createTypeMap(this.sourceClass, this.destinationClass).setPostConverter(this.mapConverter());
    }

    protected <T extends Named & Identified> String getAbstractEntityName(UUID uuid, IdentifiedService<T> service) {
        if (Objects.isNull(uuid)) {
            return null;
        }
        return Stream.of(uuid).map(id -> this.getEntityById((UUID)id, service)).filter(x$0 -> Objects.nonNull(x$0)).map(rec$ -> ((Named)rec$).getName()).filter(name -> !name.isEmpty()).findFirst().orElse(UNDEFINED);
    }

    protected <T extends Named & Identified> List<String> getAbstractEntityNames(Collection<UUID> uuids, IdentifiedService<T> service) {
        if (CollectionUtils.isEmpty(uuids)) {
            return null;
        }
        return uuids.stream().map(uuid -> this.getEntityById((UUID)uuid, service)).filter(x$0 -> Objects.nonNull(x$0)).map(rec$ -> ((Named)rec$).getName()).map(name -> !name.isEmpty() ? name : UNDEFINED).collect(Collectors.toList());
    }

    private <T extends Named & Identified> T getEntityById(UUID uuid, IdentifiedService<T> service) {
        Named entity;
        try {
            entity = (Named)service.get(uuid);
        }
        catch (Exception e) {
            log.error("Can't get entity. Cause: {}", (Object)e.getMessage());
            return null;
        }
        return (T)entity;
    }
}

