/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.model.Alert;
import org.qubership.atp.environments.model.impl.AlertImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SubscriberRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AlertRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final Provider<SubscriberRepositoryImpl> subscriberRepo;
    private final AlertProjection projection = new AlertProjection(this);

    @Autowired
    public AlertRepositoryImpl(SQLQueryFactory queryFactory, Provider<SubscriberRepositoryImpl> subscriberRepo) {
        this.queryFactory = queryFactory;
        this.subscriberRepo = subscriberRepo;
    }

    @Nullable
    public Alert getById(@Nonnull UUID id) {
        return (Alert)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERTS)).where((Predicate)AlertRepositoryImpl.ALERTS.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERTS)).where((Predicate)AlertRepositoryImpl.ALERTS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<Alert> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERTS)).fetch();
    }

    @Nonnull
    public List<Alert> getAllByParentId(@Nonnull UUID subscriberId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)ALERTS)).where((Predicate)AlertRepositoryImpl.ALERTS.subscriberId.eq((Object)subscriberId))).fetch();
    }

    @Nonnull
    public Alert create(String name, String shortDescription, String tagList, String parameters, UUID subscriberId, Integer status, Long created) {
        Timestamp createdTimestamp = new Timestamp(created);
        UUID uuid = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ALERTS).set((Path)AlertRepositoryImpl.ALERTS.name, (Object)name)).set((Path)AlertRepositoryImpl.ALERTS.shortDescription, (Object)shortDescription)).set((Path)AlertRepositoryImpl.ALERTS.tagList, (Object)tagList)).set((Path)AlertRepositoryImpl.ALERTS.parameters, (Object)parameters)).set((Path)AlertRepositoryImpl.ALERTS.subscriberId, (Object)subscriberId)).set((Path)AlertRepositoryImpl.ALERTS.status, (Object)status)).set((Path)AlertRepositoryImpl.ALERTS.created, (Object)createdTimestamp)).executeWithKey((Path)AlertRepositoryImpl.ALERTS.id);
        return this.projection.create(uuid, name, shortDescription, tagList, parameters, subscriberId, status, createdTimestamp);
    }

    @Nonnull
    public Alert update(@Nonnull UUID alertId, String name, String shortDescription, String tagList, String parameters, UUID subscriberId, Integer status, Long created) {
        Timestamp createdTimestamp = new Timestamp(created);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)ALERTS).set((Path)AlertRepositoryImpl.ALERTS.name, (Object)name)).set((Path)AlertRepositoryImpl.ALERTS.shortDescription, (Object)shortDescription)).set((Path)AlertRepositoryImpl.ALERTS.tagList, (Object)tagList)).set((Path)AlertRepositoryImpl.ALERTS.parameters, (Object)parameters)).set((Path)AlertRepositoryImpl.ALERTS.subscriberId, (Object)subscriberId)).set((Path)AlertRepositoryImpl.ALERTS.status, (Object)status)).set((Path)AlertRepositoryImpl.ALERTS.created, (Object)createdTimestamp)).where((Predicate)AlertRepositoryImpl.ALERTS.id.eq((Object)alertId))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(alertId, name, shortDescription, tagList, parameters, subscriberId, status, createdTimestamp);
    }

    public void delete(UUID alertId) {
        this.deleteReferenceToTable(alertId, (RelationalPathBase)ALERTS, (SimplePath<UUID>)AlertRepositoryImpl.ALERTS.id);
    }

    private void deleteReferenceToTable(UUID id, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)id))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class AlertProjection
    extends MappingProjection<Alert> {
        private static final long serialVersionUID = 42L;
        private final transient AlertRepositoryImpl repo;

        public AlertProjection(AlertRepositoryImpl repo) {
            super(Alert.class, (Expression[])AbstractRepository.ALERTS.all());
            this.repo = repo;
        }

        protected Alert map(Tuple tuple) {
            UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.ALERTS.id);
            assert (uuid != null);
            String name = (String)tuple.get((Expression)AbstractRepository.ALERTS.name);
            assert (name != null);
            String shortDescription = (String)tuple.get((Expression)AbstractRepository.ALERTS.shortDescription);
            assert (shortDescription != null);
            String tagList = (String)tuple.get((Expression)AbstractRepository.ALERTS.tagList);
            String parameters = (String)tuple.get((Expression)AbstractRepository.ALERTS.parameters);
            UUID subscriberId = (UUID)tuple.get((Expression)AbstractRepository.ALERTS.subscriberId);
            Integer status = (Integer)tuple.get((Expression)AbstractRepository.ALERTS.status);
            Timestamp created = (Timestamp)tuple.get((Expression)AbstractRepository.ALERTS.created);
            assert (created != null);
            return this.create(uuid, name, shortDescription, tagList, parameters, subscriberId, status, created);
        }

        protected AlertImpl create(UUID uuid, String name, String shortDescription, String tagList, String parameters, UUID subscriberId, Integer status, Timestamp created) {
            return new AlertImpl(uuid, name, shortDescription, tagList, parameters, subscriberId, status, Long.valueOf(created.getTime()));
        }
    }
}

