/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.impl.ConnectionImpl;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.repo.projections.FullConnectionProjection;
import org.qubership.atp.environments.repo.projections.IdConnectionProjection;
import org.qubership.atp.environments.service.direct.EncryptorService;
import org.qubership.atp.environments.service.direct.KafkaService;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class ConnectionRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final Provider<ConnectionRepositoryImpl> connectionRepo;
    private final EncryptorService encryptorService;
    private final Provider<SystemRepositoryImpl> systemRepo;
    private final CommitEntityService<System> commitEntityService;
    private final FullConnectionProjection projection = new FullConnectionProjection(this);
    private final IdConnectionProjection idConnectionProjection = new IdConnectionProjection(this);
    private final List<String> allServices = Arrays.asList("HealthCheck", "LogCollector", "MIA", "TDM", "TSG");
    private final KafkaService kafkaService;

    @Autowired
    public ConnectionRepositoryImpl(SQLQueryFactory queryFactory, Provider<ConnectionRepositoryImpl> connectionRepo, EncryptorService encryptorService, Provider<SystemRepositoryImpl> systemRepo, CommitEntityService<System> commitEntityService, KafkaService kafkaService) {
        this.queryFactory = queryFactory;
        this.connectionRepo = connectionRepo;
        this.encryptorService = encryptorService;
        this.systemRepo = systemRepo;
        this.commitEntityService = commitEntityService;
        this.kafkaService = kafkaService;
    }

    private boolean validateServices(List<String> services) {
        if (services != null) {
            for (String service : services) {
                if (!this.allServices.stream().noneMatch(service::equals)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Connection getById(@Nonnull UUID id) {
        return (Connection)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<Connection> getAll() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).from((Expression)CONNECTIONS)).fetch();
    }

    @Nonnull
    public List<Connection> getAll(@Nonnull UUID environmentId, @Nonnull UUID sourceTemplateId) {
        return this.getConnectionsJoinedToSystems((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId).and((Predicate)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.eq((Object)sourceTemplateId)));
    }

    @Nonnull
    public List<Connection> getAll(@Nonnull List<UUID> environmentIds, @Nonnull UUID systemCategoryId) {
        return this.getConnectionsJoinedToEnvironments((Predicate)ConnectionRepositoryImpl.ENVIRONMENTS.id.in(environmentIds).and((Predicate)ConnectionRepositoryImpl.SYSTEMS.categoryId.eq((Object)systemCategoryId)));
    }

    @Nonnull
    public List<Connection> getAll(@Nonnull UUID environmentId, @Nonnull UUID sourceTemplateId, @Nonnull UUID systemCategoryId) {
        return this.getConnectionsJoinedToSystems((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId).and((Predicate)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.eq((Object)sourceTemplateId)).and((Predicate)ConnectionRepositoryImpl.SYSTEMS.categoryId.eq((Object)systemCategoryId)));
    }

    @Nonnull
    public List<Connection> getAll(@Nonnull UUID environmentId, @Nonnull UUID sourceTemplateId, @Nonnull UUID systemCategoryId, @Nonnull UUID systemId) {
        return this.getConnectionsJoinedToSystems((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId).and((Predicate)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.eq((Object)sourceTemplateId)).and((Predicate)ConnectionRepositoryImpl.SYSTEMS.categoryId.eq((Object)systemCategoryId)).and((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)systemId)));
    }

    public List<Connection> getAllByTemplateId(@Nonnull UUID templateId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.eq((Object)templateId))).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).from((Expression)CONNECTIONS)).fetch();
    }

    public List<Connection> getConnectionsByHost(@Nonnull String host) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.parameters.like("%" + host + "%"))).fetch();
    }

    @Nonnull
    public List<Connection> getConnectionsJoinedToSystems(Predicate predicate) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).innerJoin((EntityPath)SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Expression)ConnectionRepositoryImpl.SYSTEMS.id))).innerJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.SYSTEMS.id.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).where(predicate)).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).fetch();
    }

    @Nonnull
    public List<Connection> getConnectionsJoinedToEnvironments(Predicate predicate) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).innerJoin((EntityPath)SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Expression)ConnectionRepositoryImpl.SYSTEMS.id))).innerJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.SYSTEMS.id.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).innerJoin((EntityPath)ENVIRONMENTS)).on((Predicate)ConnectionRepositoryImpl.ENVIRONMENTS.id.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId))).where(predicate)).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).fetch();
    }

    @Nonnull
    public List<Connection> getConnectionTemplates() {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where(new Predicate[]{ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.isNull(), ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)Constants.Environment.System.DEFAULT)})).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).fetch();
    }

    @Nonnull
    public Connection getConnectionTemplateByName(String name) {
        return (Connection)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where(new Predicate[]{ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.isNull(), ConnectionRepositoryImpl.CONNECTIONS.name.eq((Object)name), ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)Constants.Environment.System.DEFAULT)})).fetchOne();
    }

    @Nonnull
    @Cacheable(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    public List<Connection> getAllByParentId(@Nonnull UUID systemId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)systemId))).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).fetch();
    }

    @Nonnull
    public List<Connection> getAllShortByParentId(@Nonnull UUID systemId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.idConnectionProjection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)systemId))).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).fetch();
    }

    @Nonnull
    public Connection getByParentIdAndName(@Nonnull UUID systemId, @Nonnull String name) {
        return (Connection)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)systemId).and((Predicate)ConnectionRepositoryImpl.CONNECTIONS.name.eq((Object)name)))).fetchOne();
    }

    @Nonnull
    public List<Connection> getAllByParentIdAndConnectionType(@Nonnull UUID systemId, @Nonnull UUID connectionType) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where(new Predicate[]{ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Object)systemId), ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId.eq((Object)connectionType)})).fetch();
    }

    @Nonnull
    public UUID getSystemId(@Nonnull UUID connectionId) {
        return (UUID)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)ConnectionRepositoryImpl.CONNECTIONS.systemId).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)connectionId))).fetchOne();
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Connection create(@Nonnull UUID systemId, @Nonnull String name, String description, ConnectionParameters parameters, Long created, UUID createdBy, String connectionType, UUID sourceTemplateId, List<String> services, UUID sourceId) {
        Preconditions.checkArgument((boolean)this.validateServices(services), (String)"Cannot create connection with name \"%s\" under system \"%s\". Invalid services", (Object)name, (Object)systemId);
        Timestamp createdTimestamp = new Timestamp(created);
        parameters = this.encryptorService.encryptParameters(parameters);
        UUID uuid = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)CONNECTIONS).set((Path)ConnectionRepositoryImpl.CONNECTIONS.name, (Object)name)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.description, (Object)description)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.parameters, (Object)new Gson().toJson((Object)parameters))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.services, (Object)new Gson().toJson(CollectionUtils.isEmpty(services) ? Collections.emptyList() : services))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.created, (Object)createdTimestamp)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.createdBy, (Object)createdBy)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.modified, (Object)createdTimestamp)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.modifiedBy, (Object)createdBy)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.systemId, (Object)systemId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.connectionType, (Object)connectionType)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId, (Object)sourceTemplateId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceId, (Object)sourceId)).executeWithKey((Path)ConnectionRepositoryImpl.CONNECTIONS.id);
        ConnectionImpl connection = this.projection.create(uuid, name, description, parameters, createdTimestamp, createdBy, createdTimestamp, createdBy, systemId, connectionType, sourceTemplateId, services, sourceId);
        System system = Proxies.withId(System.class, systemId, id -> ((SystemRepositoryImpl)this.systemRepo.get()).getById((UUID)id));
        this.updateSystems(systemId, createdTimestamp, createdBy, system.getEnvironments());
        this.commitEntityService.commit(system);
        return connection;
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    public Connection create(@Nonnull UUID systemId, @Nonnull UUID connectionId, @Nonnull String name, String description, ConnectionParameters parameters, Long created, UUID createdBy, String connectionType, UUID sourceTemplateId, List<String> services, UUID sourceId) {
        Preconditions.checkArgument((boolean)this.validateServices(services), (String)"Cannot create connection with name \"%s\" under system \"%s\". Invalid services", (Object)name, (Object)systemId);
        Timestamp createdTimestamp = new Timestamp(created);
        parameters = this.encryptorService.encryptParameters(parameters);
        ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)CONNECTIONS).set((Path)ConnectionRepositoryImpl.CONNECTIONS.name, (Object)name)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.description, (Object)description)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.parameters, (Object)new Gson().toJson((Object)parameters))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.services, (Object)new Gson().toJson(CollectionUtils.isEmpty(services) ? Collections.emptyList() : services))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.created, (Object)createdTimestamp)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.systemId, (Object)systemId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.connectionType, (Object)connectionType)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId, (Object)sourceTemplateId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.id, (Object)connectionId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceId, (Object)sourceId)).execute();
        this.updateSystems(systemId, createdTimestamp, createdBy, Collections.emptyList());
        return this.projection.create(connectionId, name, description, parameters, createdTimestamp, createdBy, createdTimestamp, createdBy, systemId, connectionType, sourceTemplateId, services, sourceId);
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Connection update(@Nonnull UUID id, @Nonnull UUID systemId, @Nonnull String name, String description, ConnectionParameters parameters, Long modified, UUID modifiedBy, String connectionType, UUID sourceTemplateId, List<String> services, UUID sourceId) {
        Preconditions.checkArgument((boolean)this.validateServices(services), (String)"Cannot update connection [Name: \"%s\",ID:\"%s\"] under system \"%s\". Invalid services", (Object)name, (Object)id, (Object)systemId);
        Timestamp modifiedTimestamp = new Timestamp(modified);
        parameters = this.encryptorService.encryptParameters(parameters);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)CONNECTIONS).set((Path)ConnectionRepositoryImpl.CONNECTIONS.name, (Object)name)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.description, (Object)description)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.parameters, (Object)new Gson().toJson((Object)parameters))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.services, (Object)new Gson().toJson(CollectionUtils.isEmpty(services) ? Collections.emptyList() : services, List.class))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.modified, (Object)modifiedTimestamp)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.modifiedBy, (Object)modifiedBy)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.systemId, (Object)systemId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.connectionType, (Object)connectionType)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId, (Object)sourceTemplateId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceId, (Object)sourceId)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).execute();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{ConnectionRepositoryImpl.CONNECTIONS.created, ConnectionRepositoryImpl.CONNECTIONS.createdBy}).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).fetchOne();
        Timestamp created = (Timestamp)tuple.get((Expression)ConnectionRepositoryImpl.CONNECTIONS.created);
        UUID createdBy = (UUID)tuple.get((Expression)ConnectionRepositoryImpl.CONNECTIONS.createdBy);
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Information about connection not updated");
        System system = Proxies.withId(System.class, systemId, sysId -> ((SystemRepositoryImpl)this.systemRepo.get()).getById((UUID)sysId));
        this.sendKafkaNotification(id, system, EventType.UPDATE);
        ConnectionImpl connection = this.projection.create(id, name, description, parameters, created, createdBy, modifiedTimestamp, modifiedBy, systemId, connectionType, sourceTemplateId, services, sourceId);
        this.updateSystems(systemId, modifiedTimestamp, modifiedBy, system.getEnvironments());
        this.commitEntityService.commit(system);
        return connection;
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Connection update(@Nonnull UUID id, @Nonnull UUID systemId, @Nonnull String name, String description, ConnectionParameters parameters, Long modified, UUID modifiedBy, String connectionType, UUID sourceTemplateId, List<String> services) {
        Preconditions.checkArgument((boolean)this.validateServices(services), (String)"Cannot update connection [Name: \"%s\",ID:\"%s\"] under system \"%s\". Invalid services", (Object)name, (Object)id, (Object)systemId);
        Timestamp modifiedTimestamp = new Timestamp(modified);
        parameters = this.encryptorService.encryptParameters(parameters);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)CONNECTIONS).set((Path)ConnectionRepositoryImpl.CONNECTIONS.name, (Object)name)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.description, (Object)description)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.parameters, (Object)new Gson().toJson((Object)parameters))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.services, (Object)new Gson().toJson(CollectionUtils.isEmpty(services) ? Collections.emptyList() : services, List.class))).set((Path)ConnectionRepositoryImpl.CONNECTIONS.modified, (Object)modifiedTimestamp)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.modifiedBy, (Object)modifiedBy)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.systemId, (Object)systemId)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.connectionType, (Object)connectionType)).set((Path)ConnectionRepositoryImpl.CONNECTIONS.sourceTemplateId, (Object)sourceTemplateId)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).execute();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{ConnectionRepositoryImpl.CONNECTIONS.created, ConnectionRepositoryImpl.CONNECTIONS.createdBy, ConnectionRepositoryImpl.CONNECTIONS.sourceId}).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).fetchOne();
        Timestamp created = (Timestamp)tuple.get((Expression)ConnectionRepositoryImpl.CONNECTIONS.created);
        UUID createdBy = (UUID)tuple.get((Expression)ConnectionRepositoryImpl.CONNECTIONS.createdBy);
        UUID sourceId = (UUID)tuple.get((Expression)ConnectionRepositoryImpl.CONNECTIONS.sourceId);
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Information about connection not updated");
        System system = Proxies.withId(System.class, systemId, sysId -> ((SystemRepositoryImpl)this.systemRepo.get()).getById((UUID)sysId));
        this.sendKafkaNotification(id, system, EventType.UPDATE);
        ConnectionImpl connection = this.projection.create(id, name, description, parameters, created, createdBy, modifiedTimestamp, modifiedBy, systemId, connectionType, sourceTemplateId, services, sourceId);
        this.updateSystems(systemId, modifiedTimestamp, modifiedBy, system.getEnvironments());
        this.commitEntityService.commit(system);
        return connection;
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    public void updateParameters(UUID systemId, @Nonnull UUID id, ConnectionParameters parameters, Long modified, UUID modifiedBy, List<String> services) {
        long update;
        parameters = this.encryptorService.encryptParameters(parameters);
        Timestamp modifiedTimestamp = modified != null ? new Timestamp(modified) : new Timestamp(new Date().getTime());
        SQLUpdateClause query = this.getUpdateParametersQuery(id, parameters);
        query.set((Path)ConnectionRepositoryImpl.CONNECTIONS.modified, (Object)modifiedTimestamp);
        query.set((Path)ConnectionRepositoryImpl.CONNECTIONS.modifiedBy, (Object)modifiedBy);
        if (!CollectionUtils.isEmpty(services)) {
            query.set((Path)ConnectionRepositoryImpl.CONNECTIONS.services, (Object)new Gson().toJson(services, List.class));
        }
        Preconditions.checkArgument(((update = query.execute()) > 0L ? 1 : 0) != 0, (Object)"Information about connection not updated");
        System system = Proxies.withId(System.class, systemId, sysId -> ((SystemRepositoryImpl)this.systemRepo.get()).getById((UUID)sysId));
        this.sendKafkaNotification(id, system, EventType.UPDATE);
        this.updateSystems(systemId, modifiedTimestamp, modifiedBy, system.getEnvironments());
        this.commitEntityService.commit(system);
    }

    public SQLUpdateClause getUpdateParametersQuery(@Nonnull UUID id, ConnectionParameters parameters) {
        return (SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)CONNECTIONS).set((Path)ConnectionRepositoryImpl.CONNECTIONS.parameters, (Object)new Gson().toJson((Object)parameters))).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id));
    }

    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#systemId", condition="#systemId!=null")
    public void delete(UUID systemId, UUID id, Long modified, UUID modifiedBy) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)CONNECTIONS).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)id))).execute();
        System system = Proxies.withId(System.class, systemId, sysId -> ((SystemRepositoryImpl)this.systemRepo.get()).getById((UUID)sysId));
        this.sendKafkaNotification(id, system, EventType.DELETE);
        this.updateSystems(systemId, modifiedTimestamp, modifiedBy, system.getEnvironments());
        this.commitEntityService.commit(system);
    }

    private void sendKafkaNotification(UUID id, System system, EventType eventType) {
        UUID projectId = !CollectionUtils.isEmpty((Collection)system.getEnvironments()) ? ((Environment)system.getEnvironments().get(0)).getProjectId() : null;
        this.kafkaService.sendConnectionKafkaNotification(id, eventType, projectId);
    }

    private void updateSystems(@Nonnull UUID id, Timestamp modified, UUID modifiedBy, List<Environment> environments) {
        ((SystemRepositoryImpl)this.systemRepo.get()).updateSystemsModified(id, modified, modifiedBy, environments);
    }

    public List<String> getConnectionNameByProjectId(UUID projectId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct((Expression)ConnectionRepositoryImpl.CONNECTIONS.name).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.in((SubQueryExpression)((SQLQuery)new SQLQuery().select((Expression)ConnectionRepositoryImpl.SYSTEMS.id).from((Expression)SYSTEMS)).where((Predicate)ConnectionRepositoryImpl.SYSTEMS.id.in((SubQueryExpression)((SQLQuery)new SQLQuery().select((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.in((SubQueryExpression)((SQLQuery)new SQLQuery().select((Expression)ConnectionRepositoryImpl.ENVIRONMENTS.id).from((Expression)ENVIRONMENTS)).where((Predicate)ConnectionRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId))))))))).orderBy(ConnectionRepositoryImpl.CONNECTIONS.name.asc())).fetch();
    }

    public List<Connection> getConnectionsByProjectId(UUID projectId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct((Expression)this.projection).from((Expression)CONNECTIONS)).leftJoin((EntityPath)SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Expression)ConnectionRepositoryImpl.SYSTEMS.id))).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.SYSTEMS.id.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)ConnectionRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId))).fetch();
    }

    public List<Connection> getByIds(List<UUID> ids) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)CONNECTIONS)).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.in(ids))).fetch();
    }

    public UUID getProjectId(UUID connectionId) {
        return (UUID)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)ConnectionRepositoryImpl.ENVIRONMENTS.projectId).from((Expression)CONNECTIONS)).leftJoin((EntityPath)SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Expression)ConnectionRepositoryImpl.SYSTEMS.id))).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.SYSTEMS.id.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)ConnectionRepositoryImpl.CONNECTIONS.id.eq((Object)connectionId))).limit(1L)).fetchOne();
    }

    @Nullable
    public List<Connection> getAllByEnvironmentId(UUID environmentId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct((Expression)this.projection).from((Expression)CONNECTIONS)).leftJoin((EntityPath)SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.CONNECTIONS.systemId.eq((Expression)ConnectionRepositoryImpl.SYSTEMS.id))).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)ConnectionRepositoryImpl.SYSTEMS.id.eq((Expression)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).where((Predicate)ConnectionRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId))).fetch();
    }
}

