/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.model.Subscription;
import org.qubership.atp.environments.model.UpdateEvent;
import org.qubership.atp.environments.model.impl.UpdateEventImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SubscriptionRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UpdateEventRepositoryImpl
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final Provider<SubscriptionRepositoryImpl> subscriptionRepo;
    private final UpdateEventProjection projection = new UpdateEventProjection(this);

    @Autowired
    public UpdateEventRepositoryImpl(SQLQueryFactory queryFactory, Provider<SubscriptionRepositoryImpl> subscriptionRepo) {
        this.queryFactory = queryFactory;
        this.subscriptionRepo = subscriptionRepo;
    }

    @Nonnull
    public List<UpdateEvent> getAllByParentId(@Nonnull UUID subscriptionId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)UPDATE_EVENTS)).where((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId.eq((Object)subscriptionId))).fetch();
    }

    @Nullable
    public UpdateEvent getById(@Nonnull UUID subscriptionId, @Nonnull UUID entityId) {
        return (UpdateEvent)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)UPDATE_EVENTS)).where((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId.eq((Object)subscriptionId).and((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityId.eq((Object)entityId)))).fetchOne();
    }

    @Nullable
    public UpdateEvent getBySubscriptionId(@Nonnull UUID subscriptionId) {
        return (UpdateEvent)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)UPDATE_EVENTS)).where((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId.eq((Object)subscriptionId))).fetchOne();
    }

    @Nullable
    public UpdateEvent getByEntityId(@Nonnull UUID entityId) {
        return (UpdateEvent)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)UPDATE_EVENTS)).where((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityId.eq((Object)entityId))).fetchOne();
    }

    @Nonnull
    public List<UpdateEvent> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)UPDATE_EVENTS)).fetch();
    }

    @Nonnull
    public UpdateEvent create(@Nonnull UUID subscriptionId, @Nonnull UUID entityId, String tagList, Integer status, Long lastEventDate, String entityType) {
        Timestamp lastEventDateTimestamp = new Timestamp(lastEventDate);
        long create = ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)UPDATE_EVENTS).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId, (Object)subscriptionId)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityId, (Object)entityId)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.tagList, (Object)tagList)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.status, (Object)status)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.lastEventDate, (Object)lastEventDateTimestamp)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityType, (Object)entityType)).execute();
        Preconditions.checkArgument((create > 0L ? 1 : 0) != 0, (Object)"Nothing created");
        return this.projection.create(subscriptionId, entityId, tagList, status, lastEventDateTimestamp, entityType);
    }

    @Nonnull
    public UpdateEvent update(@Nonnull UUID subscriptionId, @Nonnull UUID entityId, String tagList, Integer status, Long lastEventDate, String entityType) {
        Timestamp lastEventDateTimestamp = new Timestamp(lastEventDate);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)UPDATE_EVENTS).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId, (Object)subscriptionId)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityId, (Object)entityId)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.tagList, (Object)tagList)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.status, (Object)status)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.lastEventDate, (Object)lastEventDateTimestamp)).set((Path)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityType, (Object)entityType)).where((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId.eq((Object)subscriptionId).and((Predicate)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityId.eq((Object)entityId)))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(subscriptionId, entityId, tagList, status, lastEventDateTimestamp, entityType);
    }

    public void delete(UUID subscriptionId, UUID entityId) {
        this.deleteReferenceToTable(subscriptionId, entityId, (RelationalPathBase)UPDATE_EVENTS, (SimplePath<UUID>)UpdateEventRepositoryImpl.UPDATE_EVENTS.subscriptionId, (SimplePath<UUID>)UpdateEventRepositoryImpl.UPDATE_EVENTS.entityId);
    }

    private void deleteReferenceToTable(UUID subscriberId, UUID entityId, RelationalPathBase path, SimplePath<UUID> simplePathSubscriber, SimplePath<UUID> simplePathEntity) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePathSubscriber.eq((Object)subscriberId).and((Predicate)simplePathEntity.eq((Object)entityId)))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class UpdateEventProjection
    extends MappingProjection<UpdateEvent> {
        static final long serialVersionUID = 42L;
        private final transient UpdateEventRepositoryImpl repo;

        public UpdateEventProjection(UpdateEventRepositoryImpl repo) {
            super(UpdateEvent.class, (Expression[])AbstractRepository.UPDATE_EVENTS.all());
            this.repo = repo;
        }

        protected UpdateEvent map(Tuple tuple) {
            UUID subscriptionId = (UUID)tuple.get((Expression)AbstractRepository.UPDATE_EVENTS.subscriptionId);
            assert (subscriptionId != null);
            UUID entityId = (UUID)tuple.get((Expression)AbstractRepository.UPDATE_EVENTS.entityId);
            assert (entityId != null);
            String tagList = (String)tuple.get((Expression)AbstractRepository.UPDATE_EVENTS.tagList);
            Integer status = (Integer)tuple.get((Expression)AbstractRepository.UPDATE_EVENTS.status);
            Timestamp lastEventDate = (Timestamp)tuple.get((Expression)AbstractRepository.UPDATE_EVENTS.lastEventDate);
            assert (lastEventDate != null);
            String entityType = (String)tuple.get((Expression)AbstractRepository.UPDATE_EVENTS.entityType);
            return this.create(subscriptionId, entityId, tagList, status, lastEventDate, entityType);
        }

        protected UpdateEventImpl create(UUID subscriptionId, UUID entityId, String tagList, Integer status, Timestamp lastEventDate, String entityType) {
            Subscription subscriptionAsObj = ((SubscriptionRepositoryImpl)this.repo.subscriptionRepo.get()).getById(subscriptionId);
            return new UpdateEventImpl(subscriptionAsObj, subscriptionId, entityId, tagList, status, Long.valueOf(lastEventDate.getTime()), entityType);
        }
    }
}

