/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.errorhandling.database.UserSettingsAlreadyExistsException;
import org.qubership.atp.environments.model.UserSetting;
import org.qubership.atp.environments.model.impl.UserSettingImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Repository;

@Repository
public class UserSettingRepositoryImpl
extends AbstractRepository {
    private static final Logger log = LoggerFactory.getLogger(UserSettingRepositoryImpl.class);
    private final SQLQueryFactory queryFactory;
    private final UserSettingProjection projection = new UserSettingProjection(this);

    @Autowired
    public UserSettingRepositoryImpl(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Nullable
    public UserSetting getByUserId(@Nonnull UUID userId) {
        return (UserSetting)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)USER_SETTINGS)).where((Predicate)UserSettingRepositoryImpl.USER_SETTINGS.userId.eq((Object)userId))).fetchOne();
    }

    @Nonnull
    public UserSetting create(@Nonnull UUID userId, @Nonnull String view) {
        try {
            long create = ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)USER_SETTINGS).set((Path)UserSettingRepositoryImpl.USER_SETTINGS.userId, (Object)userId)).set((Path)UserSettingRepositoryImpl.USER_SETTINGS.view, (Object)view)).execute();
            Preconditions.checkArgument((create > 0L ? 1 : 0) != 0, (Object)"Nothing created");
        }
        catch (DataIntegrityViolationException e) {
            log.error(String.format("Error occurred while creating new user settings. User settings for user with id %s already exists", userId));
            throw new UserSettingsAlreadyExistsException(userId);
        }
        return this.projection.create(userId, view);
    }

    @Nonnull
    public UserSetting update(@Nonnull UUID userId, @Nonnull String view) {
        long update = ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)USER_SETTINGS).set((Path)UserSettingRepositoryImpl.USER_SETTINGS.view, (Object)view)).where((Predicate)UserSettingRepositoryImpl.USER_SETTINGS.userId.eq((Object)userId))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(userId, view);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class UserSettingProjection
    extends MappingProjection<UserSetting> {
        static final long serialVersionUID = 42L;
        private final transient UserSettingRepositoryImpl repo;

        public UserSettingProjection(UserSettingRepositoryImpl repo) {
            super(UserSetting.class, (Expression[])AbstractRepository.USER_SETTINGS.all());
            this.repo = repo;
        }

        protected UserSetting map(Tuple tuple) {
            UUID userId = (UUID)tuple.get((Expression)AbstractRepository.USER_SETTINGS.userId);
            assert (userId != null);
            String view = (String)tuple.get((Expression)AbstractRepository.USER_SETTINGS.view);
            return this.create(userId, view);
        }

        protected UserSettingImpl create(UUID userId, String view) {
            return new UserSettingImpl(userId, view);
        }
    }
}

