/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.Alert;
import org.qubership.atp.environments.repo.impl.AlertRepositoryImpl;
import org.qubership.atp.environments.service.direct.AlertService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="alertService")
public class AlertServiceImpl
implements AlertService {
    private final AlertRepositoryImpl alertRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public AlertServiceImpl(AlertRepositoryImpl alertRepository, DateTimeUtil dateTimeUtil) {
        this.alertRepository = alertRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public Alert get(@Nonnull UUID id) {
        return this.alertRepository.getById(id);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.alertRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Alert> getAll() {
        return this.alertRepository.getAll();
    }

    @Override
    public Alert create(String name, String shortDescription, String tagList, String parameters, UUID subscriberId, Integer status) {
        return this.alertRepository.create(name, shortDescription, tagList, parameters, subscriberId, status, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void update(Alert alert) {
        this.alertRepository.update(alert.getId(), alert.getName(), alert.getShortDescription(), alert.getTagList(), alert.getParameters(), alert.getSubscriberId(), alert.getStatus(), this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void delete(UUID alertId) {
        this.alertRepository.delete(alertId);
    }
}

