/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.crypt.exception.AtpEncryptException;
import org.qubership.atp.environments.errorhandling.internal.EnvironmentEncryptionException;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.service.direct.EncryptorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="encryptorService")
public class EncryptorServiceImpl
implements EncryptorService {
    private static final Logger log = LoggerFactory.getLogger(EncryptorServiceImpl.class);
    private boolean useEncryption;
    protected Encryptor encryptor;
    private final String isEncryptFlag = "{2ENC}";

    @Autowired
    public EncryptorServiceImpl(@Nonnull Encryptor encryptor, @Value(value="${atp.crypto.enabled:false}") boolean useEncryption) {
        this.encryptor = encryptor;
        this.useEncryption = useEncryption;
    }

    @Override
    public ConnectionParameters encryptParameters(ConnectionParameters parameters) {
        ConnectionParameters encryptedParameters = new ConnectionParameters();
        if (parameters != null) {
            for (Map.Entry param : parameters.entrySet()) {
                String encryptedParameter = this.encryptParameter((String)param.getKey(), (String)param.getValue());
                encryptedParameters.put((Object)((String)param.getKey()), (Object)encryptedParameter);
            }
        }
        return encryptedParameters;
    }

    @Override
    public String encryptParameter(String name, String parameter) {
        if (!StringUtils.isEmpty((Object)parameter) && parameter.contains("{2ENC}")) {
            parameter = parameter.replace("{2ENC}", "");
            String originalValue = this.decodeBase64(parameter);
            if (this.useEncryption) {
                try {
                    return this.encryptString(originalValue);
                }
                catch (AtpEncryptException e) {
                    log.error("Failed to encrypt parameter: {}", (Object)name);
                    throw new EnvironmentEncryptionException(name);
                }
            }
            return originalValue;
        }
        return parameter;
    }

    @Override
    public String encryptString(String sourceParameter) throws AtpEncryptException {
        return this.encryptor.encrypt(sourceParameter.trim());
    }

    @Override
    public String decodeBase64(String source) {
        return new String(Base64.getDecoder().decode(source), StandardCharsets.UTF_8);
    }
}

