/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.environments.clients.api.catalogue.generated.ProjectDto;
import org.qubership.atp.environments.service.direct.ProjectAccessService;
import org.qubership.atp.environments.service.rest.client.CatalogFeignClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="projectAccessService")
public class ProjectAccessServiceImpl
implements ProjectAccessService {
    private static final Logger log = LoggerFactory.getLogger(ProjectAccessServiceImpl.class);
    private final CatalogFeignClient catalogClient;

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<UUID> getProjectIdsWithAccess() {
        ResponseEntity<List<ProjectDto>> response = this.catalogClient.getAllShortProjects();
        return response != null && !CollectionUtils.isEmpty((Collection)((Collection)response.getBody())) ? ((List)response.getBody()).stream().map(ProjectDto::getUuid).collect(Collectors.toList()) : Collections.emptyList();
    }

    public ProjectAccessServiceImpl(CatalogFeignClient catalogClient) {
        this.catalogClient = catalogClient;
    }
}

