/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.environments.model.Subscription;
import org.qubership.atp.environments.model.UpdateEvent;
import org.qubership.atp.environments.repo.impl.SubscriptionRepositoryImpl;
import org.qubership.atp.environments.service.direct.SubscriptionService;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subscriptionService")
public class SubscriptionServiceImpl
implements SubscriptionService {
    private final SubscriptionRepositoryImpl subscriptionRepository;
    private final DateTimeUtil dateTimeUtil;

    @Autowired
    public SubscriptionServiceImpl(SubscriptionRepositoryImpl subscriptionRepository, DateTimeUtil dateTimeUtil) {
        this.subscriptionRepository = subscriptionRepository;
        this.dateTimeUtil = dateTimeUtil;
    }

    @Override
    @Nullable
    public Subscription get(@Nonnull UUID id) {
        return this.subscriptionRepository.getById(id);
    }

    @Override
    public boolean existsById(@Nonnull UUID id) {
        return this.subscriptionRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Subscription> getAll() {
        return this.subscriptionRepository.getAll();
    }

    @Override
    @Nonnull
    public List<UUID> getListIdSubscriptionsForProject(@Nonnull UUID projectId) {
        return this.subscriptionRepository.getListIdSubscriptionsForProject(projectId);
    }

    @Override
    @Nonnull
    public List<UUID> getListIdSubscriptionsForProject(@Nonnull UUID projectId, boolean cascade) {
        return this.subscriptionRepository.getListIdSubscriptionsForProject(projectId, cascade);
    }

    @Override
    @Nonnull
    public List<UUID> getListIdSubscriptionsForEnvironment(@Nonnull UUID environmentId) {
        return this.subscriptionRepository.getListIdSubscriptionsForEnvironment(environmentId);
    }

    @Override
    @Nonnull
    public List<UUID> getListIdSubscriptionsForEnvironment(@Nonnull UUID environmentId, boolean cascade) {
        return this.subscriptionRepository.getListIdSubscriptionsForEnvironment(environmentId, cascade);
    }

    @Override
    @Nonnull
    public List<UUID> getListIdSubscriptionsForSystem(@Nonnull UUID systemId) {
        return this.subscriptionRepository.getListIdSubscriptionsForSystem(systemId);
    }

    @Override
    @Nonnull
    public List<UUID> getListIdSubscriptionsForSystem(@Nonnull UUID systemId, boolean cascade) {
        return this.subscriptionRepository.getListIdSubscriptionsForSystem(systemId, cascade);
    }

    @Override
    @Nonnull
    public List<Subscription> getSubscriberSubscriptions(@Nonnull UUID subscriberId) {
        return this.subscriptionRepository.getSubscriberSubscriptions(subscriberId);
    }

    @Override
    @Nonnull
    public List<Subscription> getProjectSubscriptions(@Nonnull UUID projectId) {
        return this.subscriptionRepository.getProjectSubscriptions(projectId);
    }

    @Override
    @Nonnull
    public List<Subscription> getEnvironmentSubscriptions(@Nonnull UUID environmentId) {
        return this.subscriptionRepository.getEnvironmentSubscriptions(environmentId);
    }

    @Override
    @Nonnull
    public List<Subscription> getSystemSubscriptions(@Nonnull UUID systemId) {
        return this.subscriptionRepository.getSystemSubscriptions(systemId);
    }

    @Override
    public Subscription create(Integer subscriptionType, UUID projectId, UUID environmentId, UUID systemId, UUID subscriberId, Integer status, Long lastUpdated) {
        return this.subscriptionRepository.create(subscriptionType, projectId, environmentId, systemId, subscriberId, status, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void update(UUID id, Integer subscriptionType, UUID projectId, UUID environmentId, UUID systemId, UUID subscriberId, Integer status, Long lastUpdated) {
        this.subscriptionRepository.update(id, subscriptionType, projectId, environmentId, systemId, subscriberId, status, this.dateTimeUtil.timestampAsUtc());
    }

    @Override
    public void delete(UUID subscriptionId) {
        this.subscriptionRepository.delete(subscriptionId);
    }

    public List<UpdateEvent> getUpdateEvents(UUID subscriptionId) {
        return null;
    }

    @Override
    public List<UUID> getListSubscriptionsByConditions(UUID projectId, UUID environmentId, UUID systemId, UUID subscriberId) {
        return this.subscriptionRepository.getListSubscriptionsByConditions(projectId, environmentId, systemId, subscriberId);
    }
}

