/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.direct.impl;

import java.util.Locale;
import org.qubership.atp.environments.enums.ExecutorTemplateEnum;
import org.qubership.atp.environments.enums.TaEngineTypeEnum;
import org.qubership.atp.environments.errorhandling.taengine.EnvironmentIllegalTaEngineTemplateException;
import org.qubership.atp.environments.service.direct.TaEngineProviderService;
import org.qubership.atp.environments.service.rest.server.dto.NewmanTemplate;
import org.qubership.atp.environments.service.rest.server.dto.TaEngineTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="taEngineProviderService")
public class TaEngineProviderServiceImpl
implements TaEngineProviderService {
    private static final Logger log = LoggerFactory.getLogger(TaEngineProviderServiceImpl.class);

    @Override
    public TaEngineTemplate getTemplate(String engineType) {
        switch (TaEngineTypeEnum.valueOf(engineType.toUpperCase(Locale.ENGLISH))) {
            case NEWMAN: {
                return new NewmanTemplate();
            }
            case EXECUTOR: {
                return ExecutorTemplateEnum.TA_ENGINE_PARAMS.getTemplate();
            }
        }
        log.error("Failed to find TA Engine Template by specified type: {}", (Object)engineType);
        throw new EnvironmentIllegalTaEngineTemplateException(engineType);
    }
}

