/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.databind.JsonNode;
import org.qubership.atp.environments.model.Project;
import org.qubership.atp.environments.model.impl.ProjectImpl;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/catalog/api/v1/projects/bulk/create"})
@ControllerAdvice
@RestController
public class CatalogController {
    private final ProjectService projectService;

    @Autowired
    public CatalogController(ProjectService projectService) {
        this.projectService = projectService;
    }

    @PostMapping
    @AuditAction(auditAction="Create project")
    public Project create(@RequestBody JsonNode jsonNode) {
        ProjectImpl project = new ProjectImpl();
        String name = jsonNode.get("project").get("name").asText();
        project.setName(name);
        project.setShortName(name);
        project.setDescription(name);
        return this.projectService.create((Project)project);
    }
}

