/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.utils.View;
import org.qubership.atp.environments.service.direct.ConcurrentModificationService;
import org.qubership.atp.environments.service.direct.ConnectionService;
import org.qubership.atp.environments.service.rest.server.dto.ConnectionByCategoryDto;
import org.qubership.atp.environments.service.rest.server.dto.ConnectionDto;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/connections"})
@RestController
public class ConnectionController {
    private final ConnectionService connectionService;
    private final ConcurrentModificationService concurrentModificationService;

    @Autowired
    public ConnectionController(ConnectionService connectionService, ConcurrentModificationService concurrentModificationService) {
        this.connectionService = connectionService;
        this.concurrentModificationService = concurrentModificationService;
    }

    @GetMapping
    @AuditAction(auditAction="Get all connections")
    public List<Connection> getConnectionsAll() {
        return this.connectionService.getAll();
    }

    @PostMapping(value={"/getAllBy"})
    @AuditAction(auditAction="Get all connections by system category id {{#connectionByCategory.systemCategoryId}}")
    public List<Connection> getConnectionsAllBy(@RequestBody ConnectionByCategoryDto connectionByCategory) {
        return this.connectionService.getAll(connectionByCategory.getEnvironmentIds(), connectionByCategory.getSystemCategoryId());
    }

    @GetMapping(value={"/{connectionId}"})
    @AuditAction(auditAction="Get connection by id {{#id.toString()}}")
    public Connection getConnection(@PathVariable(value="connectionId") UUID id) {
        return (Connection)this.connectionService.get(id);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).CONNECTION.getName(),#connection.getProjectId(),'CREATE')")
    @PostMapping
    @AuditAction(auditAction="Create connection. System id: {{#connection.systemId.toString()}}")
    public Connection createConnection(@RequestBody ConnectionDto connection) {
        Preconditions.checkNotNull((Object)connection.getName(), (Object)"Connection name can't be empty");
        Preconditions.checkNotNull((Object)connection.getSystemId(), (Object)"System ID can't be empty");
        return this.connectionService.create(connection.getSystemId(), connection.getName(), connection.getDescription(), connection.getParameters(), connection.getConnectionType(), connection.getSourceTemplateId(), connection.getProjectId(), connection.getServices());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).CONNECTION.getName(),#connectionDto.getProjectId(),'UPDATE')")
    @PutMapping
    @AuditAction(auditAction="Update connection. System id: {{#connection.systemId.toString()}} and connection id: {{#connection.id.toString()}}")
    public ResponseEntity<Connection> updateConnection(@RequestBody ConnectionDto connectionDto) {
        Preconditions.checkNotNull((Object)connectionDto.getId(), (Object)"Connection id can't be empty");
        Preconditions.checkNotNull((Object)connectionDto.getName(), (Object)"Connection name can't be empty");
        Preconditions.checkNotNull((Object)connectionDto.getSystemId(), (Object)"System ID can't be empty");
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(connectionDto.getId(), connectionDto.getModified(), this.connectionService);
        Connection updatedConnection = this.connectionService.update(connectionDto.getId(), connectionDto.getSystemId(), connectionDto.getName(), connectionDto.getDescription(), connectionDto.getParameters(), connectionDto.getConnectionType(), connectionDto.getSourceTemplateId(), connectionDto.getProjectId(), connectionDto.getServices());
        return ResponseEntity.status((HttpStatus)status).body((Object)updatedConnection);
    }

    @PutMapping(value={"/parameters"})
    @AuditAction(auditAction="Update connection parameters")
    public List<Connection> updateParameters(@RequestBody List<ConnectionDto> connections) {
        ArrayList<Connection> updatedConnections = new ArrayList<Connection>();
        for (ConnectionDto connection : connections) {
            Preconditions.checkNotNull((Object)connection.getId(), (Object)"Connection id can't be empty");
            Preconditions.checkNotNull((Object)connection.getName(), (Object)"Connection name can't be empty");
            Preconditions.checkNotNull((Object)connection.getSystemId(), (Object)"System ID can't be empty");
            this.connectionService.updateParameters(connection.getId(), connection.getParameters(), connection.getServices());
            updatedConnections.add((Connection)this.connectionService.get(connection.getId()));
        }
        return updatedConnections;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.environments.enums.UserManagementEntities).CONNECTION.getName(),@connectionService.getProjectId(#id),'DELETE')")
    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @AuditAction(auditAction="Delete connection by uuid {{#id.toString()}}")
    public void deleteConnection(@PathVariable(value="connectionId") UUID id) {
        this.connectionService.delete(id);
    }

    @GetMapping(value={"/templates"})
    @AuditAction(auditAction="Get connection templates.")
    public List<Connection> getConnectionTemplates() {
        return this.connectionService.getConnectionTemplates();
    }

    @Operation(description="Getting connection templates in abbreviated form :{id:\"\",name:\"\"}")
    @GetMapping(value={"/templates/short"})
    @JsonView(value={View.Name.class})
    @AuditAction(auditAction="Get connection templates short.")
    public List<Connection> getConnectionTemplatesShort() {
        return this.connectionService.getConnectionTemplates();
    }
}

