/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionByCategoryDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionNameViewDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="ConnectionController", description="Connection Controller")
public interface ConnectionControllerApi {
    @Operation(operationId="createConnection", summary="create", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/connections"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ConnectionDtoGenerated> createConnection(@Parameter(name="ConnectionDtoDtoGenerated", description="") @Valid @RequestBody(required=false) ConnectionDtoDtoGenerated var1);

    @Operation(operationId="deleteConnection", summary="delete", tags={"connection-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/connections/{connectionId}"})
    public ResponseEntity<Void> deleteConnection(@Parameter(name="connectionId", description="connectionId", required=true) @PathVariable(value="connectionId") UUID var1);

    @Operation(operationId="getConnection", summary="getConnection", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/connections/{connectionId}"}, produces={"application/json"})
    public ResponseEntity<ConnectionDtoGenerated> getConnection(@Parameter(name="connectionId", description="connectionId", required=true) @PathVariable(value="connectionId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getConnectionTemplates", summary="getConnectionTemplates", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/connections/templates"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionDtoGenerated>> getConnectionTemplates(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getConnectionTemplatesShort", summary="Getting connection templates in abbreviated form :{id:\"\",name:\"\"}", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionNameViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/connections/templates/short"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionNameViewDtoGenerated>> getConnectionTemplatesShort();

    @Operation(operationId="getConnectionsAll", summary="getConnectionsAll", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/connections"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionDtoGenerated>> getConnectionsAll(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getConnectionsAllBy", summary="getConnectionsAllBy", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/connections/getAllBy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ConnectionDtoGenerated>> getConnectionsAllBy(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1, @Parameter(name="ConnectionByCategoryDtoDtoGenerated", description="") @Valid @RequestBody(required=false) ConnectionByCategoryDtoDtoGenerated var2);

    @Operation(operationId="updateConnection", summary="update", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/connections"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ConnectionDtoGenerated> updateConnection(@Parameter(name="ConnectionDtoDtoGenerated", description="") @Valid @RequestBody(required=false) ConnectionDtoDtoGenerated var1);

    @Operation(operationId="updateParameters", summary="updateParameters", tags={"connection-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/connections/parameters"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ConnectionDtoGenerated>> updateParameters(@Parameter(name="ConnectionDtoDtoGenerated", description="") @Valid @RequestBody(required=false) List<ConnectionDtoDtoGenerated> var1);
}

