/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.service.rest.server.dto.generated.CompareEntityResponseDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemResponseDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="HistoryController", description="Model History API")
public interface HistoryControllerApi {
    @Operation(operationId="getAllHistory", summary="finds all changes history for defined object", tags={"history-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=HistoryItemResponseDtoGenerated.class))}), @ApiResponse(responseCode="400", description="History for Entity type = '\" + itemType + \"' is not supported"), @ApiResponse(responseCode="404", description="Entity Id not found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/history/{projectId}/{itemType}/{id}"}, produces={"application/json"})
    public ResponseEntity<HistoryItemResponseDtoGenerated> getAllHistory(@Parameter(name="projectId", description="", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="itemType", description="", required=true) @PathVariable(value="itemType") String var2, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID var3, @Parameter(name="offset", description="") @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer var4, @Parameter(name="limit", description="") @Valid @RequestParam(value="limit", required=false, defaultValue="10") Integer var5);

    @Operation(operationId="getEntitiesByVersion", summary="finds all entity's states for provided version ids", tags={"history-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompareEntityResponseDtoGenerated.class))}), @ApiResponse(responseCode="400", description="Versioning for Entity type = '\" + itemType + \"' is not supported"), @ApiResponse(responseCode="404", description="Entity Id not found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/history/version/{projectId}/{itemType}/{id}/revision/{revisionIds}"}, produces={"application/json"})
    public ResponseEntity<List<CompareEntityResponseDtoGenerated>> getEntitiesByVersion(@Parameter(name="projectId", description="", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="itemType", description="", required=true) @PathVariable(value="itemType") String var2, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID var3, @Parameter(name="revisionIds", description="", required=true) @PathVariable(value="revisionIds") List<String> var4);

    @Operation(operationId="restoreToRevision", summary="Restore the state of the provided entity to defined revision", tags={"history-controller"}, responses={@ApiResponse(responseCode="200", description="Revision was restored successfully"), @ApiResponse(responseCode="400", description="Restore for Entity type = '\" + itemType + \"' is not supported"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Entity Id not found"), @ApiResponse(responseCode="500", description="Revision was not restored. Reference to the one of the systems is invalid.")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId}"})
    public ResponseEntity<Void> restoreToRevision(@Parameter(name="projectId", description="", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="itemType", description="", required=true) @PathVariable(value="itemType") String var2, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID var3, @Parameter(name="revisionId", description="", required=true) @PathVariable(value="revisionId") Integer var4);
}

