/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.rest.server.generated;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.environments.service.rest.server.dto.generated.ConnectionFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.CreateSystemDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ParametersGettingVersionDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.ShortExternalServiceDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SynchronizeCloudServicesRequestDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemDtoDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemEnvironmentsViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer1ViewDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.SystemFullVer2ViewDtoGenerated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="SystemController", description="System Controller")
public interface SystemControllerApi {
    @Operation(operationId="copy", summary="copy", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/systems/{systemId}/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> copy(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="CreateSystemDtoDtoGenerated", description="") @Valid @RequestBody(required=false) CreateSystemDtoDtoGenerated var2);

    @Operation(operationId="createSystem", summary="create", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/systems"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> createSystem(@Parameter(name="CreateSystemDtoDtoGenerated", description="") @Valid @RequestBody(required=false) CreateSystemDtoDtoGenerated var1);

    @Operation(operationId="deleteLinkedSystems", summary="deleteLinkedSystems", tags={"system-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/systems/link/{systemId}/{environmentId}"})
    public ResponseEntity<Void> deleteLinkedSystems(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="environmentId", description="systemId", required=true) @PathVariable(value="environmentId") UUID var2);

    @Operation(operationId="deleteSystem", summary="delete", tags={"system-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/systems/{systemId}"})
    public ResponseEntity<Void> deleteSystem(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @NotNull @Parameter(name="environmentId", description="environmentId", required=true) @Valid @RequestParam(value="environmentId", required=true) UUID var2);

    @Operation(operationId="getAll", summary="getAll", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> getAll(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getAllSystems", summary="Endpoint for getting list of systems on all projects ", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemEnvironmentsViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/short"}, produces={"application/json"})
    public ResponseEntity<List<SystemEnvironmentsViewDtoGenerated>> getAllSystems(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getCachedVersion", summary="getCachedVersion", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/public/v1/systems/{systemId}/version"}, produces={"application/json"})
    public ResponseEntity<Object> getCachedVersion(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="getHtmlVersion", summary="getHtmlVersion", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/{systemId}/htmlVersion"}, produces={"text/plain"})
    public ResponseEntity<String> getHtmlVersion(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="getKubernetesServiceNames", summary="getKubernetesServiceNames", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ShortExternalServiceDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/shortKubeServices/{systemId}"}, produces={"application/json"})
    public ResponseEntity<List<ShortExternalServiceDtoGenerated>> getKubernetesServiceNames(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="getLinkedCloudServices", summary="getLinkedCloudServices", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/link/{systemId}"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> getLinkedCloudServices(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="getOpenshiftServiceNames", summary="getOpenshiftServiceNames", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ShortExternalServiceDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/shortOpenshiftServices/{systemId}"}, produces={"application/json"})
    public ResponseEntity<List<ShortExternalServiceDtoGenerated>> getOpenshiftServiceNames(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="getPublicHtmlVersion", summary="getPublicHtmlVersion", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/public/v1/systems/{systemId}/htmlVersion"}, produces={"text/plain"})
    public ResponseEntity<String> getPublicHtmlVersion(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="getShortSystem", summary="getShortSystem", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/short/{systemId}"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> getShortSystem(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getSystem", summary="getSystem", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/{systemId}"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> getSystem(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getSystemByName", summary="getSystemByName", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/byName/{environmentId}/{name}"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> getSystemByName(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="name", description="name", required=true) @PathVariable(value="name") String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getSystemConnections", summary="getSystems", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/{systemId}/connections"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionFullVer1ViewDtoGenerated>> getSystemConnections(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getSystemV2", summary="getSystemV2", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v2/systems/{systemId}"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer2ViewDtoGenerated> getSystemV2(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="openshiftUpdateRoutes", summary="openshiftUpdateRoutes", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectionFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/systems/openshift"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ConnectionFullVer1ViewDtoGenerated>> openshiftUpdateRoutes(@Parameter(name="CreateSystemDtoDtoGenerated", description="") @Valid @RequestBody(required=false) CreateSystemDtoDtoGenerated var1);

    @Operation(operationId="share", summary="share", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/systems/{systemId}/share"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer2ViewDtoGenerated> share(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @NotNull @Parameter(name="environmentId", description="environmentId", required=true) @Valid @RequestParam(value="environmentId", required=true) UUID var2, @Parameter(name="modified", description="modified") @Valid @RequestParam(value="modified", required=false) Long var3);

    @Operation(operationId="synchronizeServicesFromKubernetes", summary="synchronizeServicesFromKubernetes", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/systems/kubeServices/{environmentId}/{systemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> synchronizeServicesFromKubernetes(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var2, @Parameter(name="SynchronizeCloudServicesRequestDtoGenerated", description="") @Valid @RequestBody(required=false) SynchronizeCloudServicesRequestDtoGenerated var3);

    @Operation(operationId="synchronizeServicesFromOpenShift", summary="synchronizeServicesFromOpenShift", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/systems/openshiftServices/{environmentId}/{systemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDtoGenerated>> synchronizeServicesFromOpenShift(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var2, @Parameter(name="SynchronizeCloudServicesRequestDtoGenerated", description="") @Valid @RequestBody(required=false) SynchronizeCloudServicesRequestDtoGenerated var3);

    @Operation(operationId="unShare", summary="unShare", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/systems/{systemId}/unshare"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer2ViewDtoGenerated> unShare(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @NotNull @Parameter(name="environmentId", description="environmentId", required=true) @Valid @RequestParam(value="environmentId", required=true) UUID var2, @Parameter(name="modified", description="modified") @Valid @RequestParam(value="modified", required=false) Long var3);

    @Operation(operationId="updateParametersGettingVersion", summary="updateParametersGettingVersion", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/systems/{systemId}/parametersGettingVersion"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> updateParametersGettingVersion(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1, @Parameter(name="ParametersGettingVersionDtoGenerated", description="") @Valid @RequestBody(required=false) ParametersGettingVersionDtoGenerated var2);

    @Operation(operationId="updateServicesFromKubernetes", summary="updateServicesFromKubernetes", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/kubeServices/{systemId}"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> updateServicesFromKubernetes(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="updateServicesFromOpenshift", summary="updateServicesFromOpenshift", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/openshiftServices/{systemId}"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDtoGenerated>> updateServicesFromOpenshift(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);

    @Operation(operationId="updateSystem", summary="update", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/systems"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> updateSystem(@Parameter(name="SystemDtoDtoGenerated", description="") @Valid @RequestBody(required=false) SystemDtoDtoGenerated var1);

    @Operation(operationId="updateVersion", summary="updateVersion", tags={"system-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDtoGenerated.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/systems/{systemId}/version"}, produces={"application/json"})
    public ResponseEntity<SystemFullVer1ViewDtoGenerated> updateVersion(@Parameter(name="systemId", description="systemId", required=true) @PathVariable(value="systemId") UUID var1);
}

