/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.environments.clients.api.healthcheck.dto.StatusDto;
import org.qubership.atp.environments.clients.api.healthcheck.dto.SystemStatusDto;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.utils.enums.Status;
import org.qubership.atp.environments.service.direct.SystemService;
import org.qubership.atp.environments.service.rest.client.HealthcheckFeignClient;
import org.qubership.atp.environments.service.rest.server.dto.SystemDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class WebSocketSystemHealthCheckService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketSystemHealthCheckService.class);
    private final SystemService systemService;
    private final HealthcheckFeignClient hcFeignClient;
    private final ObjectMapper objectMapper;

    public WebSocketSystemHealthCheckService(SystemService systemService, HealthcheckFeignClient hcFeignClient) {
        this.systemService = systemService;
        this.hcFeignClient = hcFeignClient;
        this.objectMapper = new ObjectMapper();
    }

    public SystemDto checkHealth(UUID projectId, UUID environmentId, UUID systemId) throws IOException {
        StatusDto statusDto;
        SystemStatusDto systemStatusDto;
        ResponseEntity<SystemStatusDto> systemStatusDtoResponseEntity = this.hcFeignClient.checkSystem(Objects.toString(projectId, null), Objects.toString(environmentId, null), Objects.toString(systemId, null), null, null, null);
        if (systemStatusDtoResponseEntity != null && systemStatusDtoResponseEntity.getBody() != null && (systemStatusDto = (SystemStatusDto)systemStatusDtoResponseEntity.getBody()) != null && systemStatusDto.getStatus() != null && (statusDto = systemStatusDto.getStatus()) != null) {
            System system = this.systemService.saveStatusAndDateOfLastCheck(systemId, (Status)this.objectMapper.convertValue((Object)statusDto, Status.class));
            return SystemDto.convert(system);
        }
        throw new AtpIllegalNullableArgumentException("response", "Healthcheck service check system request");
    }
}

