/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.websocket;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.feign.exception.FeignClientException;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.rest.server.dto.SystemDto;
import org.qubership.atp.environments.service.websocket.SystemStatusCheckRequest;
import org.qubership.atp.environments.service.websocket.WebSocketEventType;
import org.qubership.atp.environments.service.websocket.WebSocketSystemHealthCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.stereotype.Service;

@Service
@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
public class WebSocketSystemStatusService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketSystemStatusService.class);
    private final EnvironmentService environmentService;
    private final SimpMessageSendingOperations messagingTemplate;
    private final WebSocketSystemHealthCheckService healthCheckService;

    public void processRequest(SystemStatusCheckRequest request) {
        String nullError = "Aborting sending request to Healthcheck service. %s is null. Request: %s";
        UUID projectId = (UUID)Preconditions.checkNotNull((Object)request.getProjectId(), (Object)String.format(nullError, "Project Id", request));
        if (request.getSystemId() == null && request.getEnvironmentId() != null) {
            for (System system : this.environmentService.getSystems(request.getEnvironmentId())) {
                this.processRequest(projectId, request.getEnvironmentId(), system.getId());
            }
        } else if (request.getEnvironmentId() == null) {
            for (Environment environment : this.environmentService.getByProjectId(projectId)) {
                if (environment.getSystems() == null) continue;
                for (System system : environment.getSystems()) {
                    this.processRequest(projectId, environment.getId(), system.getId());
                }
            }
        } else {
            this.processRequest(projectId, request.getEnvironmentId(), request.getSystemId());
        }
    }

    private void processRequest(UUID projectId, UUID environmentId, UUID systemId) {
        try {
            SystemDto system = this.healthCheckService.checkHealth(projectId, environmentId, systemId);
            this.messagingTemplate.convertAndSend((Object)WebSocketEventType.SYSTEM_STATUS.getDestinationPrefix(), (Object)system);
        }
        catch (FeignClientException e) {
            String env = this.extractEnvName(environmentId);
            String errTemplate = "Make sure that at least one connection of the system with id [%s] in environment %s has set 'HealthCheck' as 'use in service' field";
            log.error(e.getErrorMessage());
            throw new FeignClientException(e.getStatus(), String.format("Make sure that at least one connection of the system with id [%s] in environment %s has set 'HealthCheck' as 'use in service' field", systemId, env), e.getHttpMethod(), e.getHeaders(), e.getRequest());
        }
        catch (Exception e) {
            log.error("Error get healthcheck status: ", (Throwable)e);
        }
    }

    private String extractEnvName(UUID environmentId) {
        return this.environmentService.getOrElse(environmentId).map(e -> e.getName() + " (" + environmentId + ")").orElse(environmentId.toString());
    }

    public WebSocketSystemStatusService(EnvironmentService environmentService, SimpMessageSendingOperations messagingTemplate, WebSocketSystemHealthCheckService healthCheckService) {
        this.environmentService = environmentService;
        this.messagingTemplate = messagingTemplate;
        this.healthCheckService = healthCheckService;
    }
}

