/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.service.websocket;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.qubership.atp.auth.springbootstarter.feign.exception.FeignClientException;
import org.qubership.atp.environments.enums.MdcField;
import org.qubership.atp.environments.service.websocket.SystemStatusCheckRequest;
import org.qubership.atp.environments.service.websocket.WebSocketSystemStatusService;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;

@Controller
@MessageMapping(value={"/websocket"})
public class WebSocketSystemStatusUpdateController {
    private static final Logger log = LoggerFactory.getLogger(WebSocketSystemStatusUpdateController.class);
    private final WebSocketSystemStatusService webSocketSystemStatusService;

    @MessageMapping(value={"/system"})
    public void synchronizationActionUpdateProcess(@Payload SystemStatusCheckRequest systemStatusRequest) {
        if (systemStatusRequest != null) {
            MdcUtils.put((String)MdcField.ENVIRONMENT_ID.toString(), (UUID)systemStatusRequest.getEnvironmentId());
            MdcUtils.put((String)MdcField.SYSTEM_ID.toString(), (UUID)systemStatusRequest.getSystemId());
            log.info("Request to check status for {}", (Object)systemStatusRequest);
            try {
                this.webSocketSystemStatusService.processRequest(systemStatusRequest);
            }
            catch (FeignClientException e) {
                log.error("Feign client exception in WS controller /system, msg: {}", (Object)e.getErrorMessage());
                throw e;
            }
        }
    }

    @MessageExceptionHandler
    @SendTo(value={"/websocket/system/response/error"})
    public MultiErrorResponse<String> handleException(Exception e, @Headers @Nullable Map<String, Object> headers) {
        log.error("Error during handling socket message. headers {}", headers, (Object)e);
        String msg = e instanceof FeignClientException ? ((FeignClientException)((Object)e)).getErrorMessage() : (e.getMessage() != null && !e.getMessage().equals("null") ? e.getMessage() : "Please contact Administrator");
        List<String> errors = Collections.singletonList("Cannot complete healthcheck. " + msg);
        HttpStatus responseStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        String requestPath = headers == null ? "Headers are null" : String.valueOf(headers.getOrDefault("simpDestination", "Unknown request path"));
        return new MultiErrorResponse<String>(responseStatus.value(), requestPath, errors);
    }

    public WebSocketSystemStatusUpdateController(WebSocketSystemStatusService webSocketSystemStatusService) {
        this.webSocketSystemStatusService = webSocketSystemStatusService;
    }

    public static class MultiErrorResponse<T>
    extends ErrorResponse {
        private Collection<T> errors;

        public MultiErrorResponse(int status, String path, Collection<T> errors) {
            super(status, path);
            this.errors = errors;
        }

        public Collection<T> getErrors() {
            return this.errors;
        }

        public void setErrors(Collection<T> errors) {
            this.errors = errors;
        }

        @Override
        public String toString() {
            return "WebSocketSystemStatusUpdateController.MultiErrorResponse(errors=" + this.getErrors() + ")";
        }

        public MultiErrorResponse() {
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiErrorResponse)) {
                return false;
            }
            MultiErrorResponse other = (MultiErrorResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Collection<T> this$errors = this.getErrors();
            Collection<T> other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MultiErrorResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Collection<T> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            return result;
        }
    }

    private static class ErrorResponse {
        protected int status;
        protected String path;
        protected Date timestamp = new Date();

        ErrorResponse(int status, String path) {
            this.status = status;
            this.path = path;
        }

        public int getStatus() {
            return this.status;
        }

        public String getPath() {
            return this.path;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Date this$timestamp = this.getTimestamp();
            Date other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Date $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        public String toString() {
            return "WebSocketSystemStatusUpdateController.ErrorResponse(status=" + this.getStatus() + ", path=" + this.getPath() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public ErrorResponse() {
        }
    }
}

