/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final Charset charset = StandardCharsets.UTF_8;

    public static String getResponse(HttpResponse httpResponse, HttpRequest httpRequest) {
        HttpEntity httpEntity;
        String result = null;
        if (httpResponse != null && (httpEntity = httpResponse.getEntity()) != null) {
            try {
                result = IOUtils.toString((InputStream)httpEntity.getContent(), (Charset)charset);
            }
            catch (IOException e) {
                log.error("Can't read http entity. Method[" + httpRequest.getRequestLine().getMethod() + "]. URI[" + httpRequest.getRequestLine().getUri() + "]. Status Code[" + httpResponse.getStatusLine().getStatusCode() + "]", (Throwable)e);
            }
        }
        return result;
    }

    public static String convertToHtml(HttpEntity httpEntity) throws Exception {
        StringBuilder result = new StringBuilder();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(httpEntity.getContent(), StandardCharsets.UTF_8));){
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            rd.close();
        }
        catch (IOException ex) {
            log.error("Error on convert to html", (Throwable)ex);
        }
        return result.toString();
    }

    public static HttpClientBuilder createTrustAllHttpClientBuilder() {
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (chain, authType) -> true);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error on creating HttpClientBuilder.", (Throwable)e);
            return HttpClientBuilder.create();
        }
    }
}

