/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils.cloud;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressList;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.environments.errorhandling.clients.EnvironmentKubeClientEntityFetchException;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.service.rest.server.response.ShortExternalService;
import org.qubership.atp.environments.utils.cloud.ExternalCloudClient;
import org.qubership.atp.environments.utils.cloud.model.CloudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class KubeClient
extends ExternalCloudClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeClient.class);
    private CoreV1Api coreApi;
    private NetworkingV1Api extensionsV1beta1Api;
    private V1IngressList v1beta1IngressClassList;

    public KubeClient() {
    }

    private KubeClient(String serverUrl, String login, String password, String namespace) {
        this.configure(Config.fromUserPassword((String)serverUrl, (String)login, (String)password, (boolean)false), serverUrl, namespace);
    }

    private KubeClient(String serverUrl, String accessToken, String namespace) {
        this.configure(Config.fromToken((String)serverUrl, (String)accessToken, (boolean)false), serverUrl, namespace);
    }

    private void configure(ApiClient apiClient, String serverUrl, String namespace) {
        this.serverUrl = serverUrl;
        this.namespace = namespace;
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        this.coreApi = new CoreV1Api();
        this.extensionsV1beta1Api = new NetworkingV1Api();
    }

    @Override
    public void configure(ConnectionParameters connectionParameters) {
        String serverUrl = (String)connectionParameters.get((Object)"url");
        String login = (String)connectionParameters.get((Object)"login");
        String password = (String)connectionParameters.get((Object)"password");
        String token = (String)connectionParameters.get((Object)"token");
        this.namespace = (String)connectionParameters.get((Object)"namespace");
        if (!StringUtils.isEmpty((Object)token)) {
            this.configure(Config.fromToken((String)serverUrl, (String)token, (boolean)false), serverUrl, this.namespace);
        } else {
            this.configure(Config.fromUserPassword((String)serverUrl, (String)login, (String)password, (boolean)false), serverUrl, this.namespace);
        }
    }

    public Set<String> getImages() {
        try {
            V1PodList podList = this.coreApi.listNamespacedPod(this.namespace, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false));
            TreeSet<String> imageList = new TreeSet<String>();
            podList.getItems().forEach(pod -> {
                if (pod.getSpec() != null && pod.getSpec().getContainers() != null) {
                    pod.getSpec().getContainers().forEach(container -> {
                        if (container.getImage() != null && !container.getImage().isEmpty()) {
                            imageList.add(container.getImage());
                        }
                    });
                }
            });
            return imageList;
        }
        catch (ApiException e) {
            LOGGER.error("Failed to get pods from namespace {} , server {}", new Object[]{this.namespace, this.serverUrl, e});
            throw new EnvironmentKubeClientEntityFetchException("images");
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1ConfigMap getConfigMap(String mapName) {
        V1ConfigMap v1ConfigMap;
        try {
            v1ConfigMap = this.coreApi.readNamespacedConfigMap(mapName, this.namespace, null);
        }
        catch (ApiException e) {
            LOGGER.error("Failed to get config map with name {}, namespace {} from server {}", new Object[]{mapName, this.namespace, this.serverUrl, e});
            throw new EnvironmentKubeClientEntityFetchException("configmap");
        }
        return v1ConfigMap;
    }

    public String getIngressHost(String serviceName) {
        if (this.v1beta1IngressClassList == null || this.v1beta1IngressClassList.getItems().isEmpty()) {
            return "";
        }
        for (V1Ingress ingress : this.v1beta1IngressClassList.getItems()) {
            List ingressRule = ingress.getSpec().getRules();
            List ingressPaths = null;
            if (ingressRule != null && !ingressRule.isEmpty() && ((V1IngressRule)ingressRule.get(0)).getHttp() != null) {
                ingressPaths = ((V1IngressRule)ingressRule.get(0)).getHttp().getPaths();
            }
            if (ingressPaths == null || ingressPaths.isEmpty() || ((V1HTTPIngressPath)ingressPaths.get(0)).getBackend() == null || ((V1HTTPIngressPath)ingressPaths.get(0)).getBackend().getService() == null || !((V1HTTPIngressPath)ingressPaths.get(0)).getBackend().getService().getName().equals(serviceName)) continue;
            return ((V1IngressRule)ingressRule.get(0)).getHost() != null ? ((V1IngressRule)ingressRule.get(0)).getHost() : "";
        }
        return "";
    }

    public List<V1Service> getServicesList() {
        try {
            V1ServiceList serviceList = this.coreApi.listNamespacedService(this.namespace, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null);
            return serviceList.getItems().stream().filter(service -> Objects.nonNull(service.getMetadata()) && Objects.nonNull(service.getMetadata().getUid())).collect(Collectors.toList());
        }
        catch (ApiException e) {
            LOGGER.error("Failed to get service list with namespace {} from server {}", new Object[]{this.namespace, this.serverUrl, e});
            throw new EnvironmentKubeClientEntityFetchException("service list");
        }
    }

    public void setIngressList() {
        try {
            this.v1beta1IngressClassList = this.extensionsV1beta1Api.listNamespacedIngress(this.namespace, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOGGER.error("Failed to get ingress list with namespace {} from server {}", new Object[]{this.namespace, this.serverUrl, e});
            throw new EnvironmentKubeClientEntityFetchException("ingress list");
        }
    }

    public V1Service findServiceById(List<V1Service> serviceList, String id) {
        for (V1Service service : serviceList) {
            if (!service.getMetadata().getUid().equals(id)) continue;
            return service;
        }
        return null;
    }

    public V1Service findServiceByName(List<V1Service> serviceList, String name) {
        for (V1Service service : serviceList) {
            if (!service.getMetadata().getName().equals(name)) continue;
            return service;
        }
        return null;
    }

    @Override
    public List<ShortExternalService> getShortServices() {
        return this.getServicesList().stream().map(service -> new ShortExternalService(service.getMetadata().getUid(), service.getMetadata().getName())).collect(Collectors.toList());
    }

    public static KubeClient createKubeClient(String serverUrl, String accessToken, String login, String password, String namespace) {
        if (StringUtils.isEmpty((Object)accessToken)) {
            return new KubeClient(serverUrl, login, password, namespace);
        }
        return new KubeClient(serverUrl, accessToken, namespace);
    }

    @Override
    public List<CloudService> getServicesByServiceId(List<UUID> existingServiceIds) {
        List<V1Service> serviceList = this.getServicesList();
        ArrayList<CloudService> processedServiceList = new ArrayList<CloudService>();
        this.setIngressList();
        existingServiceIds.forEach(serviceId -> {
            V1Service serviceFromKubernetes = this.findServiceById(serviceList, serviceId.toString());
            if (serviceFromKubernetes != null) {
                processedServiceList.add(this.createCloudService(serviceFromKubernetes));
            }
        });
        return processedServiceList;
    }

    private CloudService createCloudService(V1Service serviceFromKubernetes) {
        CloudService service = new CloudService();
        String serviceName = serviceFromKubernetes.getMetadata().getName();
        service.setId(UUID.fromString(serviceFromKubernetes.getMetadata().getUid()));
        if (StringUtils.isEmpty((Object)serviceName)) {
            LOGGER.error("Service with name {} has invalid configuration", (Object)serviceName);
            throw new EnvironmentKubeClientEntityFetchException(String.format("'%s' service", serviceName));
        }
        service.setName(serviceName);
        service.setHost(this.getIngressHost(serviceName));
        return service;
    }

    @Override
    public List<CloudService> getServicesByExistingServices(List<System> existingServices) {
        List<V1Service> serviceList = this.getServicesList();
        ArrayList<CloudService> processedServiceList = new ArrayList<CloudService>();
        this.setIngressList();
        existingServices.forEach(service -> {
            V1Service serviceFromKubernetes = null;
            if (Objects.nonNull(service.getExternalId())) {
                serviceFromKubernetes = this.findServiceById(serviceList, service.getExternalId().toString());
            }
            if (Objects.isNull(serviceFromKubernetes) && Objects.nonNull(service.getExternalName())) {
                serviceFromKubernetes = this.findServiceByName(serviceList, service.getExternalName());
            }
            if (serviceFromKubernetes != null) {
                processedServiceList.add(this.createCloudService(serviceFromKubernetes));
            }
        });
        return processedServiceList;
    }
}

