/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.utils.jsch;

import com.google.common.base.Preconditions;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.environments.errorhandling.ssh.EnvironmentSshCommandRunException;
import org.qubership.atp.environments.utils.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionManager
implements Closeable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionManager.class);
    private String host;
    private int port;
    private String login;
    private String password;
    private String key;
    private String passphrase;
    private Session session;
    private int sessionTimeout;

    public SshConnectionManager(String host, int port, String login, String password, String key, String passphrase) {
        this.host = host;
        this.port = port;
        this.login = login;
        this.password = password;
        this.key = key;
        this.passphrase = passphrase;
        this.sessionTimeout = 7000;
    }

    public void open() {
        try {
            JSch jsch = new JSch();
            if (StringUtils.isNotBlank((CharSequence)this.key)) {
                byte[] keyBytes = this.key.getBytes(StandardCharsets.UTF_8);
                byte[] passphraseBytes = null;
                if (this.passphrase != null) {
                    passphraseBytes = this.passphrase.getBytes(StandardCharsets.UTF_8);
                }
                jsch.addIdentity("id_rsa", keyBytes, null, passphraseBytes);
            }
            this.session = jsch.getSession(this.login, this.host, this.port);
            this.session.setConfig(this.getProperties(this.session));
            this.session.setPassword(this.password);
            this.session.setTimeout(this.sessionTimeout);
            this.session.connect();
        }
        catch (JSchException e) {
            String messageTemplate = "Can't open ssh connection. Host: [%s], Port: [%s], Login: [%s].";
            String message = String.format(messageTemplate, this.login, this.host, this.port);
            log.error(message, (Throwable)e);
        }
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    private Properties getProperties(Session session) {
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        config.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
        config.put("cipher.c2s", session.getConfig("cipher.c2s") + ",ssh-rsa,signature.dss");
        config.put("cipher.s2c", session.getConfig("cipher.s2c") + ",ssh-rsa,signature.dss");
        config.put("server_host_key", session.getConfig("server_host_key") + ",ssh-rsa,signature.dss");
        config.put("PubkeyAcceptedAlgorithms", session.getConfig("PubkeyAcceptedAlgorithms") + ",ssh-rsa,signature.dss");
        return config;
    }

    public Optional<String> runCommand(String command) {
        try {
            return this.runCommand(command, Collectors.joining());
        }
        catch (TimeoutException e) {
            return Optional.of(e.getMessage());
        }
    }

    public <R> Optional<R> runCommand(String command, Collector<? super String, ?, R> collector) throws TimeoutException {
        Preconditions.checkState((boolean)this.session.isConnected(), (Object)"Not connected to an open session.  Call open() first!");
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setPty(false);
            channel.setCommand(command);
            channel.setInputStream(null);
            InputStream in = channel.getInputStream();
            InputStream errorIn = channel.getErrStream();
            channel.connect();
            ChannelExec finalChannel = channel;
            Optional<R> optional = Reader.readInput(() -> ((ChannelExec)finalChannel).isClosed(), in, errorIn, collector);
            return optional;
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to run SSH command: {}", (Object)command, (Object)e);
            throw new EnvironmentSshCommandRunException(command);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    @Override
    public void close() {
        try {
            this.session.disconnect();
        }
        catch (Exception e) {
            log.warn("Could not disconnect session.", (Throwable)e);
        }
    }
}

