/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.environments.errorhandling.AtpEnvironmentException;
import org.qubership.atp.environments.errorhandling.connection.EnvironmentConnectionJdbcUrlFormatException;
import org.qubership.atp.environments.errorhandling.connection.EnvironmentIllegalConnectionTypeException;
import org.qubership.atp.environments.errorhandling.database.EnvironmentDatabaseDriverLoadException;
import org.qubership.atp.environments.errorhandling.database.EnvironmentDatabaseVersionCheckException;
import org.qubership.atp.environments.errorhandling.database.EnvironmentUnsupportedDatabaseConnectionFetchException;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbVersionChecker
implements VersionChecker {
    private static final Logger log = LoggerFactory.getLogger(DbVersionChecker.class);
    private String url;
    private String host;
    private String port;
    private String name;
    private String login;
    private String password;
    private String type;
    private String parameters;

    @Override
    public void setConnectionParameters(org.qubership.atp.environments.model.Connection parameters) {
        this.host = (String)parameters.getParameters().get((Object)"db_host");
        this.port = (String)parameters.getParameters().get((Object)"db_port");
        this.name = (String)parameters.getParameters().get((Object)"db_name");
        this.login = (String)parameters.getParameters().get((Object)"db_login");
        this.password = (String)parameters.getParameters().get((Object)"db_password");
        this.type = !StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.getParameters().get((Object)"db_type"))) ? null : (String)parameters.getParameters().get((Object)"db_type");
        this.url = StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.getParameters().get((Object)"jdbc_url"))) ? (String)parameters.getParameters().get((Object)"jdbc_url") : this.getJdbcType(this.type);
    }

    private String getJdbcType(String type) {
        if ("oracle".equals(type)) {
            return "jdbc:" + type + ":thin:@" + this.host + ":" + this.port + "/" + this.name;
        }
        if ("postgresql".equals(type)) {
            return "jdbc:" + type + "://" + this.host + ":" + this.port + "/" + this.name;
        }
        if ("cassandra".equals(type)) {
            return "jdbc:" + type + "://" + this.host + ":" + this.port + "/" + this.name;
        }
        if ("mysql".equals(type)) {
            return "jdbc:" + type + "://" + this.host + ":" + this.port + "/" + this.name;
        }
        if ("mongo".equals(type)) {
            return "jdbc:" + type + "://" + this.host + ":" + this.port + "/" + this.name;
        }
        if ("hive2".equals(type)) {
            return "jdbc:" + type + "://" + this.host + ":" + this.port + "/" + this.name;
        }
        if ("bigquery".equals(type)) {
            return "jdbc:" + type + "://" + this.host + ":" + this.port;
        }
        log.error("Failed to create jdbc url for database type: {}", (Object)type);
        throw new EnvironmentConnectionJdbcUrlFormatException(type);
    }

    @Override
    public void setParametersVersionCheck(String parameters) {
        this.parameters = parameters;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public String getVersion() {
        String version = null;
        Connection dbConnection = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            dbConnection = this.getDBConnection(this.type);
            stmt = dbConnection.createStatement();
            resultSet = stmt.executeQuery(this.parameters);
            while (resultSet.next()) {
                version = resultSet.getString(1);
            }
            dbConnection.close();
            this.closeSafely(resultSet);
            this.closeSafely(stmt);
            this.closeSafely(dbConnection);
        }
        catch (AtpEnvironmentException e) {
            try {
                log.error("Error occurred while executing DbChecker", (Throwable)((Object)e));
                throw e;
                catch (SQLException e2) {
                    log.error("Failed to get database version for type '{}' by sql", (Object)this.type, (Object)e2);
                    throw new EnvironmentDatabaseVersionCheckException();
                }
            }
            catch (Throwable throwable) {
                this.closeSafely(resultSet);
                this.closeSafely(stmt);
                this.closeSafely(dbConnection);
                throw throwable;
            }
        }
        if (StringUtils.isBlank((CharSequence)version)) return "Unknown";
        String string = version;
        return string;
    }

    private void closeSafely(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                log.error("Error while occurred closing database recourse", (Throwable)exception);
            }
        }
    }

    private Connection getDBConnection(String type) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Connection> future = executor.submit(() -> DriverManager.getConnection(this.url, this.login, this.password));
        Connection connection = null;
        try {
            switch (type) {
                case "oracle": {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    break;
                }
                case "postgresql": {
                    Class.forName("org.postgresql.Driver");
                    break;
                }
                case "cassandra": 
                case "mysql": 
                case "mongo": 
                case "hive2": 
                case "bigquery": {
                    log.error("Obtaining database connection for type '{}' is unsupported", (Object)type);
                    throw new EnvironmentUnsupportedDatabaseConnectionFetchException(type);
                }
                default: {
                    log.error("Failed to find connection for type: {}", (Object)type);
                    throw new EnvironmentIllegalConnectionTypeException(type);
                }
            }
            connection = future.get(5L, TimeUnit.SECONDS);
        }
        catch (ClassNotFoundException | InterruptedException | ExecutionException | TimeoutException ex) {
            log.error("Failed to load database driver for type: {}", (Object)type, (Object)ex);
            throw new EnvironmentDatabaseDriverLoadException(type);
        }
        executor.shutdownNow();
        return connection;
    }
}

