/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.utils.jsch.SshConnectionManager;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshVersionChecker
implements VersionChecker {
    private static final Logger log = LoggerFactory.getLogger(SshVersionChecker.class);
    private String host;
    private int port = 22;
    private String login;
    private String password;
    private String key;
    private String passphrase;
    private String parameters;
    private String sessionTimeout;

    @Override
    public void setConnectionParameters(Connection parameters) {
        this.host = (String)parameters.getParameters().get((Object)"ssh_host");
        int separatorIndex = this.host.indexOf(":");
        if (separatorIndex != -1) {
            try {
                this.port = Integer.parseInt(this.host.substring(separatorIndex + 1));
            }
            catch (Exception e) {
                log.error("Can't parse port from host string. Host: " + this.host);
            }
            this.host = this.host.substring(0, separatorIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.getParameters().get((Object)"ssh_port")))) {
            this.port = Integer.parseInt((String)parameters.getParameters().get((Object)"ssh_port"));
        }
        this.login = (String)parameters.getParameters().get((Object)"ssh_login");
        this.password = (String)parameters.getParameters().get((Object)"ssh_password");
        this.key = (String)parameters.getParameters().get((Object)"ssh_key");
        this.passphrase = (String)parameters.getParameters().get((Object)"passphrase");
    }

    public void setSessionTimeout(String timeout) {
        this.sessionTimeout = timeout;
    }

    @Override
    public void setParametersVersionCheck(String parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getVersion() {
        String version = null;
        try (SshConnectionManager manager = new SshConnectionManager(this.host, this.port, this.login, this.password, this.key, this.passphrase);){
            if (StringUtils.isNotBlank((CharSequence)this.sessionTimeout)) {
                manager.setSessionTimeout(Integer.parseInt(this.sessionTimeout));
            }
            manager.open();
            Optional<String> commandResult = manager.runCommand(this.parameters);
            if (commandResult.isPresent()) {
                version = commandResult.get();
            }
        }
        catch (RuntimeException e) {
            log.error("Error on getting version by shell script. Cause: " + e.getMessage());
        }
        return !StringUtils.isBlank(version) ? version : "Unknown";
    }

    protected String processString(String inputString, boolean isTrimSpaces) {
        return isTrimSpaces ? this.trimMultipleSpaces(inputString) : inputString;
    }

    protected boolean calculateStatus(String actual, String expected) {
        return StringUtils.equals((CharSequence)actual, (CharSequence)expected);
    }

    private String trimMultipleSpaces(String inputString) {
        Pattern trimPattern = Pattern.compile("\\s+");
        Matcher matcher = trimPattern.matcher(inputString);
        return matcher.replaceAll(" ");
    }
}

