/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.version.checkers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.PathNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.version.checkers.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="ssmVersionChecker")
public class SsmVersionChecker
implements VersionChecker {
    private static final Logger log = LoggerFactory.getLogger(SsmVersionChecker.class);
    private String systemName;
    private String ssmSolutionAlias;
    private String ssmInstanceAlias;
    private String url;
    private String login;
    private String password;
    private final CloseableHttpClient httpClient;
    private static final String basePath = "/ssm-backend/api/v1/solution/%s/instance/%s/microservice";
    private static final String emptyVersion = "info_not_available";

    @Override
    public void setConnectionParameters(Connection parameters) {
        this.url = (String)parameters.getParameters().get((Object)"url");
        this.login = (String)parameters.getParameters().get((Object)"login");
        this.password = (String)parameters.getParameters().get((Object)"password");
    }

    @Override
    public void setParametersVersionCheck(String parameters) {
    }

    @Override
    public String getVersion() {
        String version;
        block6: {
            version = "";
            try {
                log.info("Get version for {} microservice from SSM by solution: {} and instance: {}", new Object[]{this.systemName, this.ssmSolutionAlias, this.ssmInstanceAlias});
                HttpGet httpRequest = new HttpGet((String)Validate.notNull((Object)this.url) + String.format(basePath, this.ssmSolutionAlias, this.ssmInstanceAlias));
                this.setAuthHeaders(httpRequest);
                httpRequest.addHeader("x-client-application-name", "NCECARE");
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString((HttpEntity)entity);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode microservicesArrayNode = mapper.readTree(content);
                if (microservicesArrayNode.isArray()) {
                    for (JsonNode microserviceNode : microservicesArrayNode) {
                        if (!microserviceNode.get("name").asText().equals(this.systemName)) continue;
                        String ver = microserviceNode.get("runTimeVersion").asText();
                        if (!emptyVersion.equals(ver)) {
                            log.info("System found microservice {} with version {}", (Object)this.systemName, (Object)ver);
                            version = ver;
                        } else {
                            log.info("System found {} microservice but version not provided", (Object)this.systemName);
                        }
                        break block6;
                    }
                    break block6;
                }
                log.warn("Not valid response from SSM server");
            }
            catch (PathNotFoundException | IOException e) {
                log.error(e.getMessage());
            }
        }
        return version.isEmpty() ? "Unknown" : version;
    }

    private void setAuthHeaders(HttpGet httpRequest) {
        String auth = this.login + ":" + this.password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
        httpRequest.setHeader("Authorization", authHeader);
    }

    public SsmVersionChecker(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setSsmSolutionAlias(String ssmSolutionAlias) {
        this.ssmSolutionAlias = ssmSolutionAlias;
    }

    public void setSsmInstanceAlias(String ssmInstanceAlias) {
        this.ssmInstanceAlias = ssmInstanceAlias;
    }
}

