/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import java.sql.Timestamp;
import java.util.Set;
import java.util.UUID;
import javax.validation.Validator;
import org.javers.core.Javers;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.errorhandling.history.EnvironmentHistoryValidationException;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.qubership.atp.environments.versioning.exception.EntityIdNotFound;
import org.qubership.atp.environments.versioning.model.entities.AbstractJaversEntity;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.qubership.atp.environments.versioning.service.JaversRestoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractJaversRestoreService<E extends AbstractJaversEntity>
implements JaversRestoreService<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJaversRestoreService.class);
    protected final Javers javers;
    protected final Validator validator;
    protected final CommitEntityService commitEntityService;
    private final DateTimeUtil dateTimeUtil;
    private final Provider<UserInfo> userInfoProvider;

    protected AbstractJaversRestoreService(Javers javers, Validator validator, CommitEntityService commitEntityService, DateTimeUtil dateTimeUtil, Provider<UserInfo> userInfoProvider) {
        this.javers = javers;
        this.validator = validator;
        this.commitEntityService = commitEntityService;
        this.dateTimeUtil = dateTimeUtil;
        this.userInfoProvider = userInfoProvider;
    }

    @Override
    @Transactional
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#id", condition="#id!=null")
    public void restore(Class<E> entityClass, UUID id, Integer revisionId) {
        log.debug("Starting restore {} with id = {} and revision = {}", new Object[]{entityClass.getSimpleName(), id, revisionId});
        E entity = this.findEntity(entityClass, id, revisionId);
        this.validateEntity(entity);
        Timestamp modified = new Timestamp(this.dateTimeUtil.timestampAsUtc());
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        this.restoreEntity(entity, modified, userId);
        log.debug("Restored {} with id = {} and revision = {}", new Object[]{entityClass.getSimpleName(), id, revisionId});
    }

    abstract void restoreEntity(E var1, Timestamp var2, UUID var3);

    private E findEntity(Class<E> entityClass, UUID id, Integer revisionId) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, entityClass).withVersion((long)revisionId.intValue()).build();
        Object javersEntity = ((Shadow)this.javers.findShadows(query).stream().findFirst().orElseThrow(EntityIdNotFound::new)).get();
        return (E)((AbstractJaversEntity)entityClass.cast(javersEntity));
    }

    private void validateEntity(E entity) {
        Set violations = this.validator.validate(entity, new Class[0]);
        if (!violations.isEmpty()) {
            log.error("Validation failed for Javers entity: {}. Violations: {}", entity, (Object)violations);
            throw new EnvironmentHistoryValidationException();
        }
    }
}

