/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import java.util.UUID;
import javax.annotation.Nonnull;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.versioning.model.entities.EnvironmentJ;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.qubership.atp.environments.versioning.service.JaversService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommitEnvironmentServiceImpl
implements CommitEntityService<Environment> {
    private static final Logger log = LoggerFactory.getLogger(CommitEnvironmentServiceImpl.class);
    private final JaversService javersService;

    @Autowired
    public CommitEnvironmentServiceImpl(JaversService javersService) {
        this.javersService = javersService;
    }

    @Override
    public void commit(@Nonnull Environment environment) {
        this.javersService.commit(new EnvironmentJ(environment));
    }

    @Override
    public void delete(@Nonnull UUID id) {
        this.javersService.commitShallowDeleteById((GlobalIdDTO)InstanceIdDTO.instanceId((Object)id, EnvironmentJ.class));
    }

    @Override
    public Class<Environment> getEntityType() {
        return Environment.class;
    }
}

