/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.javers.core.Changes;
import org.javers.core.ChangesByCommit;
import org.javers.core.Javers;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.container.ContainerChange;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.HistoryItemResponseDtoGenerated;
import org.qubership.atp.environments.service.rest.server.dto.generated.PageInfoDtoGenerated;
import org.qubership.atp.environments.versioning.model.entities.AbstractJaversEntity;
import org.qubership.atp.environments.versioning.model.values.ConnectionJ;
import org.qubership.atp.environments.versioning.service.JaversHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JaversHistoryServiceImpl
implements JaversHistoryService {
    private static final Logger log = LoggerFactory.getLogger(JaversHistoryServiceImpl.class);
    private final Javers javers;

    @Autowired
    public JaversHistoryServiceImpl(Javers javers) {
        this.javers = javers;
    }

    @Override
    public HistoryItemResponseDtoGenerated getAllHistory(UUID id, Class<? extends AbstractJaversEntity> type, Integer offset, Integer limit) {
        log.debug("Retrieving entity history. Input parameters: id = {}, type = {}, offset = {}, limit = {}", new Object[]{id, type, offset, limit});
        JqlQuery query = this.getQuery(id, type, offset, limit);
        Changes changes = this.javers.findChanges(query);
        List changesByCommits = changes.groupByCommit();
        List<HistoryItemDtoGenerated> historyItemDtoList = changesByCommits.stream().map(changesByCommit -> this.createHistoryItem(id, type, (ChangesByCommit)changesByCommit)).collect(Collectors.toList());
        HistoryItemResponseDtoGenerated response = new HistoryItemResponseDtoGenerated();
        response.setHistoryItems(historyItemDtoList);
        response.setPageInfo(this.getPageInfo(id, type, offset, limit));
        log.debug("Entity history retrieval completed. Input parameters: id = {}, type = {}, offset = {}, limit = {}. Result = {}", new Object[]{id, type, offset, limit, response});
        return response;
    }

    private HistoryItemDtoGenerated createHistoryItem(UUID id, Class<? extends AbstractJaversEntity> type, ChangesByCommit changesByCommit) {
        log.trace("Creating historyItem. Input parameters: id = {}, type = {}, changesByCommit = {}", new Object[]{id, type, changesByCommit});
        HistoryItemDtoGenerated historyItemDto = new HistoryItemDtoGenerated();
        Integer version = this.getVersionByCommit(id, type, changesByCommit.getCommit().getId());
        historyItemDto.setVersion(version);
        historyItemDto.setModifiedWhen(changesByCommit.getCommit().getCommitDate().atOffset(ZoneOffset.UTC));
        historyItemDto.setModifiedBy(changesByCommit.getCommit().getAuthor());
        changesByCommit.get().stream().filter(change -> change instanceof PropertyChange).map(change -> (PropertyChange)change).forEach(change -> this.putChangeToHistoryItem((PropertyChange)change, historyItemDto));
        log.trace("Created historyItem. Input parameters: id = {}, type = {}, changesByCommit = {}. Result = {}", new Object[]{id, type, changesByCommit, historyItemDto});
        return historyItemDto;
    }

    private void putChangeToHistoryItem(PropertyChange change, HistoryItemDtoGenerated historyItemDto) {
        log.trace("Processing propertyChange = {}", (Object)change);
        String propertyName = change.getPropertyName();
        if (change instanceof ContainerChange) {
            ContainerChange containerChange = (ContainerChange)change;
            List<?> addedValues = this.convertToSignificantValues(containerChange.getAddedValues());
            List<?> removedValues = this.convertToSignificantValues(containerChange.getRemovedValues());
            Collection intersection = CollectionUtils.intersection(addedValues, removedValues);
            addedValues.removeAll(intersection);
            removedValues.removeAll(intersection);
            if (CollectionUtils.isNotEmpty((Collection)intersection)) {
                historyItemDto.addChangedItem(propertyName);
            }
            if (CollectionUtils.isNotEmpty(addedValues)) {
                historyItemDto.addAddedItem(propertyName);
            }
            if (CollectionUtils.isNotEmpty(removedValues)) {
                historyItemDto.addDeletedItem(propertyName);
            }
        } else {
            historyItemDto.addChangedItem(propertyName);
        }
    }

    private Integer getVersionByCommit(UUID id, Class<? extends AbstractJaversEntity> type, CommitId commitId) {
        JqlQuery query = this.getQuery(id, type, commitId);
        return (int)((CdoSnapshot)this.javers.findSnapshots(query).get(0)).getVersion();
    }

    private List<?> convertToSignificantValues(List<?> values) {
        Object obj;
        if (!values.isEmpty() && (obj = values.get(0)) instanceof ConnectionJ) {
            return values.stream().map(connectionJ -> ((ConnectionJ)connectionJ).getId()).collect(Collectors.toList());
        }
        return values;
    }

    private PageInfoDtoGenerated getPageInfo(UUID id, Class<? extends AbstractJaversEntity> type, Integer offset, Integer limit) {
        PageInfoDtoGenerated pageInfo = new PageInfoDtoGenerated();
        pageInfo.setOffset(offset);
        pageInfo.setLimit(limit);
        Changes changes = this.javers.findChanges(this.getQuery(id, type));
        int countOfCommits = changes.groupByCommit().size();
        pageInfo.setItemsTotalCount(countOfCommits);
        return pageInfo;
    }

    private JqlQuery getQuery(UUID id, Class<? extends AbstractJaversEntity> type, Integer offset, Integer limit) {
        return QueryBuilder.byInstanceId((Object)id, type).withNewObjectChanges().skip(offset.intValue()).limit(limit.intValue()).build();
    }

    private JqlQuery getQuery(UUID id, Class<? extends AbstractJaversEntity> type, CommitId commitId) {
        return QueryBuilder.byInstanceId((Object)id, type).withCommitId(commitId).build();
    }

    private JqlQuery getQuery(UUID id, Class<? extends AbstractJaversEntity> type) {
        return QueryBuilder.byInstanceId((Object)id, type).withNewObjectChanges().build();
    }
}

