/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.UUID;
import javax.validation.Validator;
import org.javers.core.Javers;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.qubership.atp.environments.versioning.model.entities.EnvironmentJ;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.qubership.atp.environments.versioning.service.impl.AbstractJaversRestoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JaversRestoreEnvironmentServiceImpl
extends AbstractJaversRestoreService<EnvironmentJ> {
    private static final Logger log = LoggerFactory.getLogger(JaversRestoreEnvironmentServiceImpl.class);
    private final SQLQueryFactory queryFactory;
    private final EnvironmentRepositoryImpl environmentRepository;

    @Autowired
    public JaversRestoreEnvironmentServiceImpl(Javers javers, Validator validator, CommitEntityService<Environment> commitEntityService, DateTimeUtil dateTimeUtil, Provider<UserInfo> userInfoProvider, SQLQueryFactory queryFactory, EnvironmentRepositoryImpl environmentRepository) {
        super(javers, validator, commitEntityService, dateTimeUtil, userInfoProvider);
        this.queryFactory = queryFactory;
        this.environmentRepository = environmentRepository;
    }

    @Override
    void restoreEntity(EnvironmentJ entity, Timestamp modified, UUID modifiedBy) {
        log.debug("Restoring environment: updating simple fields: {}", (Object)entity);
        UUID environmentId = entity.getId();
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)AbstractRepository.ENVIRONMENTS).set((Path)AbstractRepository.ENVIRONMENTS.name, (Object)entity.getName())).set((Path)AbstractRepository.ENVIRONMENTS.description, (Object)entity.getDescription())).set((Path)AbstractRepository.ENVIRONMENTS.modified, (Object)modified)).set((Path)AbstractRepository.ENVIRONMENTS.modifiedBy, (Object)modifiedBy)).set((Path)AbstractRepository.ENVIRONMENTS.projectId, (Object)entity.getProjectId())).set((Path)AbstractRepository.ENVIRONMENTS.categoryId, (Object)entity.getCategoryId())).set((Path)AbstractRepository.ENVIRONMENTS.tags, (Object)this.environmentRepository.createTagsPgObject(entity.getTags()))).where((Predicate)AbstractRepository.ENVIRONMENTS.id.eq((Object)environmentId))).execute();
        this.commitEntityService.commit(this.environmentRepository.getById(environmentId));
    }

    @Override
    public Class<EnvironmentJ> getEntityType() {
        return EnvironmentJ.class;
    }
}

