/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.versioning.service.impl;

import com.google.gson.Gson;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.validation.Validator;
import org.javers.core.Javers;
import org.javers.core.diff.changetype.container.SetChange;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.utils.DateTimeUtil;
import org.qubership.atp.environments.versioning.model.entities.SystemJ;
import org.qubership.atp.environments.versioning.model.values.ConnectionJ;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.qubership.atp.environments.versioning.service.impl.AbstractJaversRestoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class JaversRestoreSystemServiceImpl
extends AbstractJaversRestoreService<SystemJ> {
    private static final Logger log = LoggerFactory.getLogger(JaversRestoreSystemServiceImpl.class);
    private final SQLQueryFactory queryFactory;
    private final SystemRepositoryImpl systemRepository;
    private final Gson gson = new Gson();

    @Autowired
    public JaversRestoreSystemServiceImpl(Javers javers, Validator validator, CommitEntityService<System> commitEntityService, DateTimeUtil dateTimeUtil, Provider<UserInfo> userInfoProvider, SQLQueryFactory queryFactory, SystemRepositoryImpl systemRepository) {
        super(javers, validator, commitEntityService, dateTimeUtil, userInfoProvider);
        this.queryFactory = queryFactory;
        this.systemRepository = systemRepository;
    }

    @Override
    void restoreEntity(SystemJ entity, Timestamp modified, UUID modifiedBy) {
        this.updateSimpleSystemFields(entity, modified, modifiedBy);
        this.restoreConnectionList(entity, modified, modifiedBy);
        System system = this.systemRepository.getById(entity.getId());
        this.commitEntityService.commit(system);
    }

    @Override
    public Class<SystemJ> getEntityType() {
        return SystemJ.class;
    }

    private void updateSimpleSystemFields(SystemJ systemJ, Timestamp modified, UUID modifiedBy) {
        log.debug("Restoring system: updating simple fields: {}", (Object)systemJ);
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)AbstractRepository.SYSTEMS).set((Path)AbstractRepository.SYSTEMS.name, (Object)systemJ.getName())).set((Path)AbstractRepository.SYSTEMS.description, (Object)systemJ.getDescription())).set((Path)AbstractRepository.SYSTEMS.modified, (Object)modified)).set((Path)AbstractRepository.SYSTEMS.modifiedBy, (Object)modifiedBy)).set((Path)AbstractRepository.SYSTEMS.categoryId, (Object)systemJ.getSystemCategoryId())).set((Path)AbstractRepository.SYSTEMS.parametersGettingVersion, (Object)this.gson.toJson((Object)systemJ.getParametersGettingVersion()))).set((Path)AbstractRepository.SYSTEMS.serverItf, (Object)this.gson.toJson((Object)systemJ.getServerItf()))).where((Predicate)AbstractRepository.SYSTEMS.id.eq((Object)systemJ.getId()))).execute();
    }

    private void restoreConnectionList(SystemJ systemJForRestore, Timestamp modified, UUID modifiedBy) {
        UUID systemId = systemJForRestore.getId();
        System system = this.systemRepository.getById(systemId);
        SystemJ actualSystemJ = new SystemJ(system);
        this.javers.compare((Object)systemJForRestore, (Object)actualSystemJ).getChangesByType(SetChange.class).stream().filter(setChange -> "connections".equals(setChange.getPropertyName())).findFirst().ifPresent(setChange -> {
            List addedConnections = setChange.getAddedValues();
            for (Object addedConnection : addedConnections) {
                UUID connectionId = ((ConnectionJ)addedConnection).getId();
                log.debug("Restoring system with id = {}: deleting connection with id = {}", (Object)systemId, (Object)connectionId);
                this.deleteConnection(connectionId);
            }
            List removedConnections = setChange.getRemovedValues();
            for (Object removedConnection : removedConnections) {
                log.debug("Restoring system with id = {}: inserting connection: {}", (Object)systemId, removedConnection);
                this.insertConnection((ConnectionJ)removedConnection, systemId, modified, modifiedBy);
            }
        });
    }

    private void deleteConnection(UUID connectionId) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)AbstractRepository.CONNECTIONS).where((Predicate)AbstractRepository.CONNECTIONS.id.eq((Object)connectionId))).execute();
    }

    private void insertConnection(ConnectionJ connectionJ, UUID systemId, Timestamp modified, UUID modifiedBy) {
        ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)AbstractRepository.CONNECTIONS).set((Path)AbstractRepository.CONNECTIONS.id, (Object)connectionJ.getId())).set((Path)AbstractRepository.CONNECTIONS.name, (Object)connectionJ.getName())).set((Path)AbstractRepository.CONNECTIONS.description, (Object)connectionJ.getDescription())).set((Path)AbstractRepository.CONNECTIONS.created, (Object)modified)).set((Path)AbstractRepository.CONNECTIONS.createdBy, (Object)modifiedBy)).set((Path)AbstractRepository.CONNECTIONS.modified, (Object)modified)).set((Path)AbstractRepository.CONNECTIONS.modifiedBy, (Object)modifiedBy)).set((Path)AbstractRepository.CONNECTIONS.systemId, (Object)systemId)).set((Path)AbstractRepository.CONNECTIONS.parameters, (Object)this.gson.toJson((Object)connectionJ.getParameters()))).set((Path)AbstractRepository.CONNECTIONS.connectionType, (Object)connectionJ.getConnectionType())).set((Path)AbstractRepository.CONNECTIONS.sourceTemplateId, (Object)connectionJ.getSourceTemplateId())).set((Path)AbstractRepository.CONNECTIONS.services, (Object)new Gson().toJson(CollectionUtils.isEmpty(connectionJ.getServices()) ? Collections.emptyList() : connectionJ.getServices(), List.class))).execute();
    }
}

