/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.util.ArrayList;
import java.util.List;
import org.javers.core.commit.CommitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandedOutIds {
    private static final Logger logger = LoggerFactory.getLogger(HandedOutIds.class);
    private int qLimit = 50;
    private List<CommitId> handedOutList = new ArrayList<CommitId>();

    HandedOutIds() {
    }

    void put(CommitId handedOut) {
        int found = this.findExistingIndex(handedOut.getMajorId());
        if (found >= 0) {
            this.handedOutList.remove(found);
            this.handedOutList.add(found, handedOut);
            this.maintainQueueSize(found);
        } else {
            int insertTo = this.findInsertIndex(handedOut.getMajorId());
            this.handedOutList.add(insertTo, handedOut);
            this.maintainQueueSize(insertTo);
        }
    }

    private void maintainQueueSize(int touchedIndex) {
        if (touchedIndex < this.qLimit / 2) {
            if (this.handedOutList.size() > this.qLimit) {
                this.handedOutList.remove(this.handedOutList.size() - 1);
            }
        } else {
            this.qLimit += this.qLimit / 10;
        }
    }

    private int findInsertIndex(Long majorId) {
        int i;
        if (this.handedOutList.size() == 0) {
            return 0;
        }
        for (i = 0; i < this.handedOutList.size() && this.handedOutList.get(i).getMajorId() > majorId; ++i) {
        }
        if (i == this.handedOutList.size()) {
            logger.error("DANGER, inserting {} at the end of handedOutList: ", (Object)majorId);
            logger.error(this.handedOutList.toString());
        }
        return i;
    }

    private int findExistingIndex(Long majorId) {
        for (int i = 0; i < this.handedOutList.size(); ++i) {
            CommitId c = this.handedOutList.get(i);
            if (c.getMajorId() == majorId.longValue()) {
                return i;
            }
            if (c.getMajorId() >= majorId) continue;
            return -1;
        }
        return -1;
    }

    CommitId get(Long majorId) {
        for (CommitId id : this.handedOutList) {
            if (id.getMajorId() != majorId.longValue()) continue;
            return id;
        }
        return null;
    }
}

