/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.qubership.atp.environments.cache.EnvironmentHazelcastCache;
import org.qubership.atp.environments.model.utils.HazelcastMapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.support.NoOpCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@EnableCaching
@Profile(value={"!test"})
public class HazelcastConfig {
    private static final Logger log = LoggerFactory.getLogger(HazelcastConfig.class);
    @Value(value="${hazelcast.enable-caching}")
    private boolean cachingIsEnable;
    @Value(value="${hazelcast.system-versions.cache-period}")
    private int cacheVersionsPeriod;
    @Value(value="${hazelcast.connections-by-system-id.cache-period}")
    private int cacheConnectionsBySystemIdPeriod;
    @Value(value="${hazelcast.environments_by_system_id.cache-period}")
    private int cacheEnvironmentsBySystemIdsPeriod;
    @Value(value="${hazelcast.systems_by_environment_id.cache-period}")
    private int cacheSystemsByEnvironmentIdPeriod;
    public static final String CONNECTION_TEMPLATES_CACHE = "CONNECTION_TEMPLATES_CACHE";
    @Value(value="${hazelcast.cluster-name}")
    private String clusterName;
    @Value(value="${hazelcast.address}")
    private String hazelcastAddress;

    @Bean
    @ConditionalOnProperty(name={"hazelcast.enable-caching"}, havingValue="true")
    public ClientConfig hazelCastConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setClusterName(this.clusterName);
        clientConfig.setInstanceName("atp-environment-" + UUID.randomUUID());
        clientConfig.getNetworkConfig().addAddress(new String[]{this.hazelcastAddress});
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        return clientConfig;
    }

    @Bean(name={"hazelcastClient"})
    @ConditionalOnProperty(name={"hazelcast.enable-caching"}, havingValue="true")
    public HazelcastInstance hazelcastClient(ClientConfig hazelCastConfig) {
        if (this.cachingIsEnable) {
            return HazelcastClient.getOrCreateHazelcastClient((ClientConfig)hazelCastConfig);
        }
        return null;
    }

    @Bean(name={"systemCachedMap"})
    public Cache systemCachedMap(CacheManager cacheManager) {
        return cacheManager != null && cacheManager.getCache("ATP_ENVIRONMENTS-SYSTEM_VERSION") != null ? cacheManager.getCache("ATP_ENVIRONMENTS-SYSTEM_VERSION") : new NoOpCache("ATP_ENVIRONMENTS-SYSTEM_VERSION");
    }

    public static void clearHazelcastMap(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance != null) {
            List existingMapNames = hazelcastInstance.getDistributedObjects().stream().map(DistributedObject::getName).collect(Collectors.toList());
            Arrays.stream(HazelcastMapName.class.getFields()).forEach(mapNameField -> {
                try {
                    String mapName = (String)mapNameField.get(null);
                    if (existingMapNames.stream().anyMatch(name -> name.equals(mapName))) {
                        hazelcastInstance.getMap(mapName).evictAll();
                    }
                }
                catch (IllegalAccessException e) {
                    log.error("Error while occurred evict map", (Throwable)e);
                }
            });
        }
    }

    @Bean
    public CacheManager cacheManager(@Autowired(required=false) @Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        ArrayList<Object> caches = new ArrayList<Object>();
        caches.add(new CaffeineCache(CONNECTION_TEMPLATES_CACHE, Caffeine.newBuilder().recordStats().expireAfterWrite(6L, TimeUnit.HOURS).build(), true));
        if (this.cachingIsEnable) {
            HazelcastConfig.clearHazelcastMap(hazelcastClient);
            caches.add(new EnvironmentHazelcastCache((IMap<Object, Object>)hazelcastClient.getMap("ATP_ENVIRONMENTS-SYSTEM_VERSION"), this.cacheVersionsPeriod, TimeUnit.SECONDS));
            caches.add(new EnvironmentHazelcastCache((IMap<Object, Object>)hazelcastClient.getMap("ATP_ENVIRONMENTS-CONNECTIONS"), this.cacheConnectionsBySystemIdPeriod, TimeUnit.SECONDS));
            caches.add(new EnvironmentHazelcastCache((IMap<Object, Object>)hazelcastClient.getMap("ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID"), this.cacheEnvironmentsBySystemIdsPeriod, TimeUnit.SECONDS));
            caches.add(new EnvironmentHazelcastCache((IMap<Object, Object>)hazelcastClient.getMap("ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"), this.cacheSystemsByEnvironmentIdPeriod, TimeUnit.SECONDS));
            caches.add(new ConcurrentMapCache("projects", CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(100L).build().asMap(), true));
        } else {
            caches.add(new CaffeineCache("ATP_ENVIRONMENTS-SYSTEM_VERSION", Caffeine.newBuilder().recordStats().expireAfterWrite((long)this.cacheVersionsPeriod, TimeUnit.SECONDS).build(), true));
            caches.add(new CaffeineCache("ATP_ENVIRONMENTS-CONNECTIONS", Caffeine.newBuilder().recordStats().expireAfterWrite((long)this.cacheConnectionsBySystemIdPeriod, TimeUnit.SECONDS).build(), true));
            caches.add(new CaffeineCache("ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID", Caffeine.newBuilder().recordStats().expireAfterWrite((long)this.cacheEnvironmentsBySystemIdsPeriod, TimeUnit.SECONDS).build(), true));
            caches.add(new CaffeineCache("ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID", Caffeine.newBuilder().recordStats().expireAfterWrite((long)this.cacheSystemsByEnvironmentIdPeriod, TimeUnit.SECONDS).build(), true));
            caches.add(new CaffeineCache("projects", Caffeine.newBuilder().recordStats().expireAfterWrite(2L, TimeUnit.MINUTES).maximumSize(100L).build(), true));
        }
        cacheManager.setCaches(caches);
        return cacheManager;
    }
}

