/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.db.ContextInterceptor;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.service.direct.impl.MetricService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.CssLinkResourceTransformer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionResourceResolver;

@Configuration
public class AppConfiguration
implements WebMvcConfigurer {
    private final ContextRepository repo;
    private final MetricService metricService;
    @Value(value="${spring.resources.static-locations}")
    private String webLocation;
    @Value(value="${application.web.root-page}")
    private String rootPage;
    @Value(value="${spring.resources.cache.period}")
    private Integer cachePeriodInSec;

    public AppConfiguration(ContextRepository repo, MetricService metricService) {
        this.repo = repo;
        this.metricService = metricService;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{this.webLocation}).setCachePeriod(this.cachePeriodInSec).resourceChain(true).addResolver((ResourceResolver)new VersionResourceResolver().addContentVersionStrategy(new String[]{"/** ** "})).addTransformer((ResourceTransformer)new CssLinkResourceTransformer()).addResolver((ResourceResolver)new PathResourceResolver(){

            protected Resource getResource(@Nonnull String resourcePath, Resource location) throws IOException {
                Resource requestedResource = location.createRelative(resourcePath);
                if (requestedResource.exists() && requestedResource.isReadable()) {
                    return location.createRelative(resourcePath);
                }
                return new FileSystemResource(AppConfiguration.this.rootPage);
            }
        });
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ContextInterceptor(this.repo, this.metricService)).addPathPatterns(new String[]{"/api/**"}).addPathPatterns(new String[]{"/catalog/**"});
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new SimpleModule().setSerializerModifier((BeanSerializerModifier)new SerModif(this.repo)));
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new SimpleModule().addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeSerializer()));
        objectMapper.enable(SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID);
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setObjectMapper(objectMapper);
        converters.add(0, (HttpMessageConverter<?>)jsonConverter);
    }

    static class SerModif
    extends BeanSerializerModifier {
        private final ContextRepository contextRepo;

        private SerModif(ContextRepository contextRepo) {
            this.contextRepo = contextRepo;
        }

        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (Identified.class.isAssignableFrom(beanDesc.getBeanClass()) && serializer instanceof BeanSerializerBase) {
                return new FlatSerializer(this.contextRepo, (BeanSerializerBase)serializer);
            }
            return serializer;
        }
    }

    static class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        private static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

        OffsetDateTimeSerializer() {
        }

        public void serialize(OffsetDateTime odt, JsonGenerator generator, SerializerProvider sp) throws IOException {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
            generator.writeString(formatter.format(odt));
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class FlatSerializer
    extends BeanSerializerBase {
        static final long serialVersionUID = 42L;
        private final transient ContextRepository contextRepo;
        BeanSerializerBase defaultSerializer;

        public FlatSerializer(ContextRepository contextRepo, BeanSerializerBase src) {
            super(src);
            this.contextRepo = contextRepo;
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, Set<String> toIgnore, ContextRepository contextRepo) {
            super(src, toIgnore);
            this.contextRepo = contextRepo;
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, ObjectIdWriter oiw, ContextRepository contextRepo) {
            super(src, oiw);
            this.defaultSerializer = src;
            this.contextRepo = contextRepo;
        }

        protected FlatSerializer(BeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties, ContextRepository contextRepo) {
            super(src, properties, filteredProperties);
            this.contextRepo = contextRepo;
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude, ContextRepository contextRepo) {
            super(src, toIgnore, toInclude);
            this.contextRepo = contextRepo;
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, ObjectIdWriter oiw, Object filterId, ContextRepository contextRepo) {
            super(src, oiw, filterId);
            this.defaultSerializer = src;
            this.contextRepo = contextRepo;
        }

        public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
            return new FlatSerializer(this.defaultSerializer, objectIdWriter, this.contextRepo);
        }

        protected BeanSerializerBase withIgnorals(Set<String> toIgnore) {
            return new FlatSerializer(this.defaultSerializer, toIgnore, this.contextRepo);
        }

        protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
            return new FlatSerializer((BeanSerializerBase)this, toIgnore, toInclude, this.contextRepo);
        }

        protected BeanSerializerBase asArraySerializer() {
            if (this._objectIdWriter == null && this._anyGetterWriter == null && this._propertyFilterId == null) {
                return new BeanAsArraySerializer((BeanSerializerBase)this);
            }
            return this;
        }

        public BeanSerializerBase withFilterId(Object filterId) {
            return new FlatSerializer((BeanSerializerBase)this, this._objectIdWriter, filterId, this.contextRepo);
        }

        protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
            return new FlatSerializer((BeanSerializerBase)this, properties, filteredProperties, this.contextRepo);
        }

        public void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (this._objectIdWriter != null) {
                gen.setCurrentValue(bean);
                this.flatSerializeWithObjectId(bean, gen, provider, true, () -> this.asId(gen));
                return;
            }
            gen.writeStartObject(bean);
            if (this._propertyFilterId != null) {
                this.serializeFieldsFiltered(bean, gen, provider);
            } else {
                this.serializeFields(bean, gen, provider);
            }
            gen.writeEndObject();
        }

        protected void flatSerializeWithObjectId(Object bean, JsonGenerator gen, SerializerProvider provider, boolean startEndObject, Supplier<Boolean> asId) throws IOException {
            ObjectIdWriter w = this._objectIdWriter;
            WritableObjectId objectId = provider.findObjectId(bean, w.generator);
            if ("Array".equals(gen.getOutputContext().typeDesc())) {
                boolean b = w.alwaysAsId || asId.get() != false;
                Object id = objectId.generateId(bean);
                if (b && id != null) {
                    w.serializer.serialize(id, gen, provider);
                    return;
                }
                this.fullSerialize(bean, gen, provider, startEndObject, w, objectId);
            } else {
                Object id = objectId.generateId(bean);
                if (w.alwaysAsId || asId.get().booleanValue()) {
                    w.serializer.serialize(id, gen, provider);
                    return;
                }
                this.fullSerialize(bean, gen, provider, startEndObject, w, objectId);
            }
        }

        private void fullSerialize(Object bean, JsonGenerator gen, SerializerProvider provider, boolean startEndObject, ObjectIdWriter w, WritableObjectId objectId) throws IOException {
            if (startEndObject) {
                gen.writeStartObject(bean);
            }
            objectId.writeAsField(gen, provider, w);
            if (this._propertyFilterId != null) {
                this.serializeFieldsFiltered(bean, gen, provider);
            } else {
                this.serializeFields(bean, gen, provider);
            }
            if (startEndObject) {
                gen.writeEndObject();
            }
        }

        private boolean asId(JsonGenerator gen) {
            JsonStreamContext current = gen.getOutputContext();
            if (this.contextRepo.getContext().isFullSerialization()) {
                if (this.contextRepo.getContext().getUnfoldPredicate().test(gen.getOutputContext())) {
                    return false;
                }
                Identified parent = null;
                Identified child = (Identified)current.getCurrentValue();
                while (!current.inRoot()) {
                    Object objToCheck = (current = current.getParent()).getCurrentValue();
                    if (objToCheck == null || !Identified.class.isAssignableFrom(objToCheck.getClass()) || child.equals(objToCheck)) continue;
                    parent = (Identified)objToCheck;
                    break;
                }
                if (parent == null) {
                    return false;
                }
                return !child.isParent(parent);
            }
            while (!current.inRoot()) {
                Object objToCheck = (current = current.getParent()).getCurrentValue();
                if (objToCheck == null || !Identified.class.isAssignableFrom(objToCheck.getClass())) continue;
                return true;
            }
            return false;
        }
    }
}

