/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db;

import com.google.common.base.Preconditions;
import com.google.common.reflect.Reflection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.utils.Utils;

public class Proxies {
    public static <T extends Identified> T withId(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
        return (T)((Identified)Reflection.newProxy(type, new IdBasedCachingH(type, id, sourceFunc)));
    }

    public static <T> List<T> list(@Nonnull Supplier<List<T>> sup) {
        return Proxies.base(List.class, sup);
    }

    public static <T> T base(@Nonnull Class<T> type, @Nonnull Supplier<? extends T> sup) {
        return (T)Reflection.newProxy(type, new CachingH(type, sup));
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    @NotThreadSafe
    private static class IdBasedCachingH<T extends Identified>
    implements InvocationHandler,
    Serializable {
        static final long serialVersionUID = 42L;
        private final Class<T> type;
        private final UUID id;
        private final transient Function<UUID, ? extends T> sourceFunc;
        private boolean initialized;
        private T cachedValue;

        private IdBasedCachingH(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
            this.type = type;
            this.id = id;
            this.sourceFunc = sourceFunc;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (this.initialized) {
                return method.invoke(this.cachedValue, args);
            }
            switch (methodName = method.getName()) {
                case "equals": {
                    Object target = args[0];
                    return proxy == target || Utils.isEqual(this.type, (UUID)this.id, (Object)target);
                }
                case "hashCode": {
                    return Objects.hashCode(this.id);
                }
                case "getId": {
                    return this.id;
                }
            }
            this.cachedValue = (Identified)Preconditions.checkNotNull((Object)((Identified)this.sourceFunc.apply(this.id)), (String)"[%s] with id [%s] is not provided by [%s]", this.type, (Object)this.id, this.sourceFunc);
            this.initialized = true;
            return method.invoke(this.cachedValue, args);
        }

        public String toString() {
            return String.format("[%s with id: %s]", this.type.getSimpleName(), this.id);
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    @NotThreadSafe
    private static class CachingH<T>
    implements InvocationHandler,
    Serializable {
        static final long serialVersionUID = 42L;
        private final Class<T> type;
        private final transient Supplier<? extends T> sup;
        private boolean initialized;
        private T cachedValue;

        private CachingH(@Nonnull Class<T> type, @Nonnull Supplier<? extends T> sup) {
            this.type = type;
            this.sup = sup;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.initialized) {
                return method.invoke(this.cachedValue, args);
            }
            this.cachedValue = Preconditions.checkNotNull(this.sup.get(), (String)"[%s] is not provided by [%s]", this.type, this.sup);
            this.initialized = true;
            return method.invoke(this.cachedValue, args);
        }
    }
}

