/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.changes.v3;

import org.qubership.atp.environments.errorhandling.ssh.EnvironmentSqlConnectionSshKeyEncryptException;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.service.direct.EncryptorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EncryptingSshKeyCustomTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptingSshKeyCustomTask.class);
    private final EncryptorService encryptor;
    private final ConnectionRepositoryImpl connectionRepository;
    private final String sshKeyParameterName = "ssh_key";

    public EncryptingSshKeyCustomTask(EncryptorService encryptor, ConnectionRepositoryImpl connectionRepository) {
        this.encryptor = encryptor;
        this.connectionRepository = connectionRepository;
    }

    public void execute() {
        LOGGER.info("Starting migration encrypting of ssh key");
        this.connectionRepository.getAllByTemplateId(Constants.Environment.System.Connection.SSH).forEach(connection -> {
            try {
                ConnectionParameters parameters = connection.getParameters();
                if (parameters.containsKey((Object)"ssh_key") && !StringUtils.isEmpty((Object)parameters.get((Object)"ssh_key"))) {
                    parameters.put((Object)"ssh_key", (Object)this.encryptor.encryptString((String)parameters.get((Object)"ssh_key")));
                    this.connectionRepository.getUpdateParametersQuery(connection.getId(), parameters).execute();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while encrypting ssh key of Connection [id: {}, name: {}]", new Object[]{connection.getId(), connection.getName(), e});
                throw new EnvironmentSqlConnectionSshKeyEncryptException();
            }
        });
        LOGGER.info("Migration encrypting of ssh key finished");
    }
}

