/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.db.modification.afterbefore;

import java.util.UUID;
import org.aopalliance.intercept.MethodInvocation;
import org.qubership.atp.environments.db.modification.EntityTypeStrategy;
import org.qubership.atp.environments.db.modification.ModificationInterceptor;
import org.qubership.atp.environments.db.modification.afterbefore.TrackedMethodStrategy;
import org.qubership.atp.environments.errorhandling.internal.EnvironmentNotIdentifiableObjectException;
import org.qubership.atp.environments.model.Identified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateStrategy
implements TrackedMethodStrategy {
    private static final Logger log = LoggerFactory.getLogger(CreateStrategy.class);
    private static Logger LOG = LoggerFactory.getLogger(CreateStrategy.class);
    private final ModificationInterceptor interceptor;
    private final EntityTypeStrategy idsStrategy;

    public CreateStrategy(ModificationInterceptor interceptor, EntityTypeStrategy idsStrategy) {
        this.interceptor = interceptor;
        this.idsStrategy = idsStrategy;
    }

    @Override
    public Object proceed(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        try {
            UUID id;
            if (result instanceof Identified) {
                id = ((Identified)result).getId();
            } else if (result instanceof UUID) {
                id = (UUID)result;
            } else {
                log.error("Returned object expected to be Identified or UUID, but was: {}", result.getClass());
                throw new EnvironmentNotIdentifiableObjectException();
            }
            this.idsStrategy.prepareNotification(id, this.interceptor).run();
        }
        catch (Exception e) {
            LOG.error("Can not handle event for " + invocation.getMethod().getName(), (Throwable)e);
        }
        return result;
    }
}

