/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.ei.service;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.environments.ei.model.Environment;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateNameChecker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateNameChecker.class);
    private final SystemRepositoryImpl systemRepository;

    public void checkAndCorrectName(Environment object, Function<Environment, Boolean> isNameUsedFunction) {
        int i = 0;
        String initName = object.getName();
        while (isNameUsedFunction.apply(object).booleanValue()) {
            String newName = i == 0 ? (initName = object.getName() + " Copy") : initName + " _" + i;
            object.setName(newName);
            ++i;
        }
    }

    public void checkAndCorrectSystemName(org.qubership.atp.environments.ei.model.System system, Environment environment, System originalSystem) {
        int i = 0;
        String initName = system.getName();
        while (this.isSystemNameUsed(environment, system, originalSystem)) {
            String newName = i == 0 ? (initName = system.getName() + " Copy") : initName + " _" + i;
            system.setName(newName);
            ++i;
        }
    }

    public boolean isSystemNameUsed(Environment environment, org.qubership.atp.environments.ei.model.System system, System originalSystem) {
        List<Tuple> fromBase = originalSystem != null && CollectionUtils.isNotEmpty((Collection)originalSystem.getEnvironments()) ? this.systemRepository.checkSystemNameIsUniqueUnderEnvironments(originalSystem.getEnvironments().stream().map(Identified::getId).collect(Collectors.toList()), system.getName()) : this.systemRepository.checkSystemNameIsUniqueUnderEnvironment(environment.getId(), system.getName());
        return !CollectionUtils.isEmpty(fromBase) && fromBase.stream().noneMatch(base -> Objects.equals(base.get((Expression)AbstractRepository.SYSTEMS.id), system.getId()));
    }

    public DuplicateNameChecker(SystemRepositoryImpl systemRepository) {
        this.systemRepository = systemRepository;
    }
}

