/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.ei.service;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.environments.ei.model.Connection;
import org.qubership.atp.environments.ei.model.Environment;
import org.qubership.atp.environments.ei.model.System;
import org.qubership.atp.environments.ei.service.DuplicateNameChecker;
import org.qubership.atp.environments.errorhandling.connection.EnvironmentIncompatibleCategoryException;
import org.qubership.atp.environments.errorhandling.internal.EnvironmentImportFileLoadException;
import org.qubership.atp.environments.model.ConnectionParameters;
import org.qubership.atp.environments.model.Identified;
import org.qubership.atp.environments.model.ServerItf;
import org.qubership.atp.environments.model.Sourced;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.utils.Constants;
import org.qubership.atp.environments.service.direct.ConnectionService;
import org.qubership.atp.environments.service.direct.EnvironmentService;
import org.qubership.atp.environments.service.direct.ProjectService;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.qubership.atp.environments.service.direct.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentsImporter {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsImporter.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final EnvironmentService environmentService;
    private final SystemService systemService;
    private final SystemCategoriesService systemCategoriesService;
    private final ConnectionService connectionService;
    private final ProjectService projectService;
    private final DuplicateNameChecker duplicateNameChecker;
    private final Decryptor decryptor;

    public void importEnvironments(Path workDir, ExportImportData importData) throws Exception {
        log.info("Starts importEnvironments(workDir: {})", (Object)workDir);
        Map environmentsFiles = this.objectLoaderFromDiskService.getListOfObjects(workDir, Environment.class);
        log.debug("importEnvironments list: {}", (Object)environmentsFiles);
        Map<UUID, UUID> invertedRepMap = new HashMap(importData.getReplacementMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        environmentsFiles.forEach((environmentId, path) -> {
            Environment environmentObject;
            log.debug("importEnvironments starts import id: {}.", environmentId);
            if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
                HashMap map = new HashMap(importData.getReplacementMap());
                environmentObject = (Environment)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, Environment.class, map, true, false);
            } else {
                environmentObject = (Environment)this.objectLoaderFromDiskService.loadFileAsObject(path, Environment.class);
            }
            log.debug("Imports object: {}", (Object)environmentObject);
            if (environmentObject == null) {
                log.error("Failed to load the import file using the path: {}", path);
                throw new EnvironmentImportFileLoadException(path.toString());
            }
            UUID projectId = environmentObject.getProjectId();
            this.createProjectIfNotExists(projectId);
            this.checkCategoryCompatibility(environmentObject);
            Optional<org.qubership.atp.environments.model.Environment> environmentOpt = this.environmentService.getOrElse(environmentObject.getId());
            if (!environmentOpt.isPresent()) {
                environmentObject.setSourceId((UUID)environmentId);
                this.createWithCheckName(environmentObject);
            } else {
                this.updateWithCheckName(environmentObject, environmentOpt.get());
            }
            this.importSystems(environmentObject, invertedRepMap);
        });
        log.info("End of importEnvironments(workDir: {})", (Object)workDir);
    }

    private void updateWithCheckName(Environment environmentObject, org.qubership.atp.environments.model.Environment environment) {
        this.checkAndCorrectName(environmentObject);
        environment.setName(environmentObject.getName());
        environment.setDescription(environmentObject.getDescription());
        environment.setProjectId(environmentObject.getProjectId());
        this.environmentService.update(environment);
    }

    private void createWithCheckName(Environment environment) {
        this.checkAndCorrectName(environment);
        this.environmentService.replicate(environment.getProjectId(), environment.getId(), environment.getName(), environment.getGraylogName(), environment.getDescription(), environment.getSsmSolutionAlias(), environment.getSsmInstanceAlias(), environment.getConsulEgressConfigPath(), environment.getCategoryId(), environment.getSourceId(), environment.getTags());
    }

    public void checkAndCorrectName(Environment environment) {
        this.duplicateNameChecker.checkAndCorrectName(environment, env -> this.isNameUsed((Environment)env));
    }

    private boolean isNameUsed(Environment environment) {
        org.qubership.atp.environments.model.Environment fromBase = this.environmentService.getByNameAndProjectId(environment.getName(), environment.getProjectId());
        return fromBase != null && !fromBase.getId().equals(environment.getId());
    }

    private void checkCategoryCompatibility(Environment objectToImport) {
        UUID importObjectCategoryId = objectToImport.getCategoryId();
        UUID environmentCategoryId = Constants.Environment.Category.ENVIRONMENT;
        UUID toolCategoryId = Constants.Environment.Category.TOOL;
        if (!importObjectCategoryId.equals(environmentCategoryId) && !importObjectCategoryId.equals(toolCategoryId)) {
            log.error("Incompatible categories ids. In System ENVIRONMENT {}, TOOL {}. Import entity category {}", new Object[]{environmentCategoryId, toolCategoryId, importObjectCategoryId});
            throw new EnvironmentIncompatibleCategoryException();
        }
    }

    private void createProjectIfNotExists(UUID projectId) {
        try {
            boolean ifProjectExists = this.projectService.existsById(projectId);
            log.debug("Project {}, ifProjectExists {}", (Object)projectId, (Object)ifProjectExists);
            if (!ifProjectExists) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyyHH:mm:ss");
                this.projectService.replicate(projectId, "Exported VA " + simpleDateFormat.format(new Date()), "Exported VA " + simpleDateFormat.format(new Date()), null, System.currentTimeMillis());
            }
        }
        catch (AtpException e) {
            String message = String.format("Cannot create project with id %s", projectId);
            throw new ExportException(message, (Throwable)e);
        }
    }

    private void importSystems(Environment environment, Map<UUID, UUID> invertedRepMap) {
        List<org.qubership.atp.environments.ei.model.System> systemsFromFile = environment.getSystems();
        Map<UUID, org.qubership.atp.environments.model.System> originalSystems = this.getOriginalSystemMap(environment);
        Map<UUID, SystemCategory> systemCategoryMap = this.systemCategoriesService.getAll().stream().collect(Collectors.toMap(Identified::getId, category -> category));
        systemsFromFile.forEach(systemFromFile -> {
            log.info("Imports system {} for environment {}.", systemFromFile, (Object)environment);
            org.qubership.atp.environments.model.System system = (org.qubership.atp.environments.model.System)originalSystems.get(systemFromFile.getId());
            this.duplicateNameChecker.checkAndCorrectSystemName((org.qubership.atp.environments.ei.model.System)systemFromFile, environment, system);
            ServerItf serverItf = new ServerItf();
            System.ServerItf serverItfFromFile = systemFromFile.getServerItf();
            if (serverItfFromFile != null) {
                serverItf.setName(serverItfFromFile.getName());
                serverItf.setUrl(serverItfFromFile.getUrl());
            }
            if (system == null) {
                this.systemService.replicate(environment.getId(), systemFromFile.getId(), systemFromFile.getName(), systemFromFile.getDescription(), systemFromFile.getSystemCategoryId(), systemFromFile.getParametersGettingVersion(), systemFromFile.getParentSystemId(), serverItf, systemFromFile.getLinkToSystemId(), systemFromFile.getExternalId(), invertedRepMap.getOrDefault(systemFromFile.getId(), null), systemFromFile.getExternalName());
            } else {
                system.setExternalId(systemFromFile.getExternalId());
                system.setExternalName(systemFromFile.getExternalName());
                system.setName(systemFromFile.getName());
                system.setDescription(systemFromFile.getDescription());
                system.setParentSystemId(systemFromFile.getParentSystemId());
                if (systemFromFile.getSystemCategoryId() != null) {
                    system.setSystemCategory((SystemCategory)systemCategoryMap.get(systemFromFile.getSystemCategoryId()));
                }
                system.setServerItf(serverItf);
                this.systemService.update(system);
                boolean isSharedWithImporting = system.getEnvironments().stream().anyMatch(environment1 -> environment.getId().equals(environment1.getId()));
                if (!isSharedWithImporting) {
                    this.systemService.share(system, Collections.singletonList(environment.getId()));
                }
            }
            this.importConnections((org.qubership.atp.environments.ei.model.System)systemFromFile, invertedRepMap);
            log.info("End of import system {} for environment {}.", systemFromFile, (Object)environment);
        });
    }

    private void importConnections(org.qubership.atp.environments.ei.model.System systemFromFile, Map<UUID, UUID> invertedRepMap) {
        List<Connection> connections = systemFromFile.getConnections();
        Map<UUID, org.qubership.atp.environments.model.Connection> originalConnections = this.connectionService.getByIds(connections.stream().map(Connection::getId).collect(Collectors.toList())).stream().collect(Collectors.toMap(Identified::getId, connection -> connection));
        connections.forEach(connectionFromFile -> {
            log.info("Imports connection {} for system {}.", connectionFromFile, (Object)systemFromFile);
            org.qubership.atp.environments.model.Connection connection = (org.qubership.atp.environments.model.Connection)originalConnections.get(connectionFromFile.getId());
            if (connection == null) {
                connection = this.connectionService.getByParentAndName(connectionFromFile.getSystemId(), connectionFromFile.getName());
            }
            ConnectionParameters newConnectionParameters = new ConnectionParameters();
            newConnectionParameters.setValidation(false);
            newConnectionParameters.putAll(connectionFromFile.getParameters());
            if (connection == null) {
                this.connectionService.replicate(systemFromFile.getId(), connectionFromFile.getId(), connectionFromFile.getName(), connectionFromFile.getDescription(), newConnectionParameters, connectionFromFile.getConnectionType(), connectionFromFile.getSourceTemplateId(), connectionFromFile.getServices(), invertedRepMap.getOrDefault(connectionFromFile.getId(), null));
            } else {
                connection.setName(connectionFromFile.getName());
                connection.setDescription(connectionFromFile.getDescription());
                connection.setSourceTemplateId(connectionFromFile.getSourceTemplateId());
                connection.setConnectionType(connectionFromFile.getConnectionType());
                connection.setParameters(this.updateConnectionParameters(connection.getParameters(), newConnectionParameters));
                connection.setSystemId(systemFromFile.getId());
                connection.setServices(connectionFromFile.getServices());
                this.connectionService.update(connection);
            }
            log.info("End of import connection {} for system {}.", connectionFromFile, (Object)systemFromFile);
        });
    }

    private ConnectionParameters updateConnectionParameters(ConnectionParameters existingParameters, ConnectionParameters newParameters) {
        ConnectionParameters updatedParameters = new ConnectionParameters();
        updatedParameters.setValidation(false);
        for (Map.Entry newParameter : newParameters.entrySet()) {
            String newKey = (String)newParameter.getKey();
            String newValue = (String)newParameter.getValue();
            if (existingParameters.containsKey((Object)newKey) && this.decryptor.isEncrypted((String)existingParameters.get((Object)newKey))) {
                updatedParameters.put((Object)newKey, (Object)((String)existingParameters.get((Object)newKey)));
                continue;
            }
            updatedParameters.put((Object)newKey, (Object)newValue);
        }
        return updatedParameters;
    }

    public List<String> preValidateEnvironments(Path workDir, boolean isInterProjectImport, Map<UUID, UUID> repMap) {
        ArrayList<String> result = new ArrayList<String>();
        Map environmentsFiles = this.objectLoaderFromDiskService.getListOfObjects(workDir, Environment.class);
        environmentsFiles.forEach((id, path) -> {
            Environment environment = this.getEnvironmentFromFile(isInterProjectImport, repMap, (Path)path);
            log.debug("Pre validating object {}", (Object)environment);
            if (environment != null && !CollectionUtils.isEmpty(environment.getSystems())) {
                for (org.qubership.atp.environments.ei.model.System system : environment.getSystems()) {
                    result.addAll(this.preValidateConnections(system, environment));
                }
            }
        });
        return result;
    }

    public List<String> preValidateConnections(org.qubership.atp.environments.ei.model.System system, Environment environment) {
        ArrayList<String> messages = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(system.getConnections())) {
            for (Connection connection : system.getConnections()) {
                try {
                    ConnectionParameters parameters = new ConnectionParameters();
                    parameters.putAll(connection.getParameters());
                    this.connectionService.validateTaEngineProviderParameters(connection.getSourceTemplateId(), parameters);
                }
                catch (Exception e) {
                    String category = environment.getCategoryId().equals(Constants.Environment.Category.TOOL) ? "TA Tool" : "Environment";
                    messages.add(String.format("%s[Name:%s, ID:%s]  - System[Name:%s, ID:%s]  - Connection [Name:%s, ID:%s] ", category, environment.getName(), environment.getId(), system.getName(), system.getId(), connection.getName(), connection.getId() + e.getMessage()));
                }
            }
        }
        return messages;
    }

    private Environment getEnvironmentFromFile(boolean isInterProjectImport, Map<UUID, UUID> repMap, Path path) {
        Environment environment = isInterProjectImport ? (Environment)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, Environment.class, repMap) : (Environment)this.objectLoaderFromDiskService.loadFileAsObject(path, Environment.class);
        return environment;
    }

    public List<String> validateEnvironments(Path workDir, boolean isInterProjectImport, Map<UUID, UUID> repMap) {
        log.info("Starts validateEnvironments(workDir: {})", (Object)workDir);
        ArrayList<String> result = new ArrayList<String>();
        Map environmentsFiles = this.objectLoaderFromDiskService.getListOfObjects(workDir, Environment.class);
        environmentsFiles.forEach((id, path) -> {
            Environment object = this.getEnvironmentFromFile(isInterProjectImport, repMap, (Path)path);
            Map<UUID, org.qubership.atp.environments.model.System> originalSystems = this.getOriginalSystemMap(object);
            log.debug("importing object {}", (Object)object);
            if (object == null) {
                String message = String.format("Cannot load file by path %s", path.toString());
                log.error(message);
                result.add(message);
                return;
            }
            if (this.isNameUsed(object)) {
                String message = String.format("Environment with name '%s' already exists under the project. Imported one will be renamed to '%s Copy'", object.getName(), object.getName());
                result.add(message);
                for (org.qubership.atp.environments.ei.model.System system : object.getSystems()) {
                    if (!this.duplicateNameChecker.isSystemNameUsed(object, system, originalSystems.get(system.getId()))) continue;
                    String systemMessage = String.format("System with name '%s' already exists under the environment '%s'. Imported one will be renamed to '%s Copy'", system.getName(), object.getName(), system.getName());
                    result.add(systemMessage);
                }
            }
        });
        return result;
    }

    public List<UUID> getObjectIds(Path workDir) {
        Map environmentsFiles = this.objectLoaderFromDiskService.getListOfObjects(workDir, Environment.class);
        ArrayList<UUID> objectIds = new ArrayList<UUID>(environmentsFiles.keySet());
        environmentsFiles.forEach((id, path) -> {
            Environment object = (Environment)this.objectLoaderFromDiskService.loadFileAsObject(path, Environment.class);
            object.getSystems().forEach(system -> {
                objectIds.add(system.getId());
                objectIds.addAll(system.getConnections().stream().map(Connection::getId).collect(Collectors.toList()));
            });
        });
        return objectIds;
    }

    public void fillRepMapWithSourceTargetValues(Map<UUID, UUID> replacementMap, Path workDir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, Environment.class);
        objectsToImport.forEach((id, path) -> {
            if (!replacementMap.containsKey(id)) {
                Environment object = (Environment)this.objectLoaderFromDiskService.loadFileAsObject((Path)objectsToImport.get(id), Environment.class);
                org.qubership.atp.environments.model.Environment existingObject = this.environmentService.getBySourceIdAndProjectId((UUID)id, (UUID)replacementMap.get(object.getProjectId()));
                if (existingObject == null) {
                    replacementMap.put((UUID)id, (UUID)null);
                    object.getSystems().forEach(sys -> {
                        replacementMap.put(sys.getId(), null);
                        sys.getConnections().forEach(con -> replacementMap.put(con.getId(), null));
                    });
                } else {
                    replacementMap.put((UUID)id, existingObject.getId());
                    Map existingSourceIdSystemsMap = existingObject.getSystems().stream().filter(system -> system.getSourceId() != null).collect(Collectors.toMap(Sourced::getSourceId, Function.identity()));
                    object.getSystems().forEach(importSys -> {
                        if (existingSourceIdSystemsMap.containsKey(importSys.getId())) {
                            org.qubership.atp.environments.model.System existingSys = (org.qubership.atp.environments.model.System)existingSourceIdSystemsMap.get(importSys.getId());
                            this.collectCollectionSourceTargetMapForExistingSystem(replacementMap, (org.qubership.atp.environments.ei.model.System)importSys, existingSys);
                        } else {
                            org.qubership.atp.environments.model.System sysWithoutEnv = this.systemService.getBySourceId(importSys.getId());
                            if (sysWithoutEnv == null) {
                                replacementMap.put(importSys.getId(), null);
                                importSys.getConnections().forEach(con -> replacementMap.put(con.getId(), null));
                            } else {
                                this.collectCollectionSourceTargetMapForExistingSystem(replacementMap, (org.qubership.atp.environments.ei.model.System)importSys, sysWithoutEnv);
                            }
                        }
                    });
                }
            }
        });
    }

    private void collectCollectionSourceTargetMapForExistingSystem(Map<UUID, UUID> replacementMap, org.qubership.atp.environments.ei.model.System importSys, org.qubership.atp.environments.model.System sysWithoutEnv) {
        replacementMap.put(importSys.getId(), sysWithoutEnv.getId());
        Map existingSourceIdConnectionMap = sysWithoutEnv.getConnections().stream().filter(system -> system.getSourceId() != null).collect(Collectors.toMap(Sourced::getSourceId, Function.identity()));
        importSys.getConnections().forEach(importConn -> {
            if (existingSourceIdConnectionMap.containsKey(importConn.getId())) {
                replacementMap.put(importConn.getId(), ((org.qubership.atp.environments.model.Connection)existingSourceIdConnectionMap.get(importConn.getId())).getId());
            } else {
                replacementMap.put(importConn.getId(), null);
            }
        });
    }

    private Map<UUID, org.qubership.atp.environments.model.System> getOriginalSystemMap(Environment environment) {
        if (environment == null || CollectionUtils.isEmpty(environment.getSystems())) {
            return Collections.emptyMap();
        }
        List<org.qubership.atp.environments.ei.model.System> systemsFromFile = environment.getSystems();
        return this.systemService.getByIds(systemsFromFile.stream().map(org.qubership.atp.environments.ei.model.System::getId).collect(Collectors.toList())).stream().collect(Collectors.toMap(Identified::getId, system -> system));
    }

    public EnvironmentsImporter(ObjectLoaderFromDiskService objectLoaderFromDiskService, EnvironmentService environmentService, SystemService systemService, SystemCategoriesService systemCategoriesService, ConnectionService connectionService, ProjectService projectService, DuplicateNameChecker duplicateNameChecker, Decryptor decryptor) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.environmentService = environmentService;
        this.systemService = systemService;
        this.systemCategoriesService = systemCategoriesService;
        this.connectionService = connectionService;
        this.projectService = projectService;
        this.duplicateNameChecker = duplicateNameChecker;
        this.decryptor = decryptor;
    }
}

