/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.mapper;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.atp.environments.mapper.AbstractVersioningMapper;
import org.qubership.atp.environments.mapper.ConnectionVersioningMapper;
import org.qubership.atp.environments.service.direct.SystemCategoriesService;
import org.qubership.atp.environments.versioning.model.entities.SystemJ;
import org.qubership.atp.environments.versioning.model.mapper.ConnectionVersioning;
import org.qubership.atp.environments.versioning.model.mapper.SystemVersioning;
import org.qubership.atp.environments.versioning.model.values.ConnectionJ;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemVersioningMapper
extends AbstractVersioningMapper<SystemJ, SystemVersioning> {
    private final SystemCategoriesService systemCategoriesService;
    private final ConnectionVersioningMapper connectionVersioningMapper;

    @Autowired
    public SystemVersioningMapper(SystemCategoriesService systemCategoriesService, ConnectionVersioningMapper connectionVersioningMapper) {
        super(SystemJ.class, SystemVersioning.class);
        this.systemCategoriesService = systemCategoriesService;
        this.connectionVersioningMapper = connectionVersioningMapper;
    }

    @Override
    void mapSpecificFields(SystemJ source, SystemVersioning destination) {
        Set<ConnectionJ> connections = source.getConnections();
        if (Objects.nonNull(connections)) {
            List<ConnectionVersioning> connectionVersionings = connections.stream().map(this.connectionVersioningMapper::map).collect(Collectors.toList());
            destination.setConnections(connectionVersionings);
        }
        destination.setSystemCategoryName(this.getAbstractEntityName(source.getSystemCategoryId(), this.systemCategoriesService));
    }
}

