/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.List;
import org.javers.core.metamodel.object.SnapshotType;
import org.qubership.atp.environments.model.response.JaversCountResponse;
import org.qubership.atp.environments.model.response.JaversVersionResponse;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JaversSnapshotRepositoryImpl
extends AbstractRepository {
    private static final String GLOBAL_ID = "globalId";
    private static final String COMMIT_ID = "commitId";
    private static final String COUNT = "count";
    private static final String VERSION = "version";
    private final SQLQueryFactory queryFactory;

    @Autowired
    public JaversSnapshotRepositoryImpl(SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public List<JaversVersionResponse> getTerminatedSnapshots() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)Projections.fields(JaversVersionResponse.class, (Expression[])new Expression[]{JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.as(GLOBAL_ID), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.commitFk.as(COMMIT_ID), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.version.as(VERSION)})).from((Expression)JV_SNAPSHOT)).where((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.in(this.getTerminalGlobalIds()))).fetch();
    }

    public List<JaversCountResponse> getGlobalIdAndCount(Integer count) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)Projections.fields(JaversCountResponse.class, (Expression[])new Expression[]{JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.as(GLOBAL_ID), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.count().as(COUNT)})).from((Expression)JV_SNAPSHOT)).groupBy((Expression)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk)).having((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.count().gt((Number)count))).fetch();
    }

    public List<JaversVersionResponse> getOld(Long globalId, Long count) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)Projections.fields(JaversVersionResponse.class, (Expression[])new Expression[]{JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.as(GLOBAL_ID), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.commitFk.as(COMMIT_ID), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.version.as(VERSION)})).from((Expression)JV_SNAPSHOT)).where((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.eq((Object)globalId))).orderBy(JaversSnapshotRepositoryImpl.JV_SNAPSHOT.version.asc())).limit(count.longValue())).fetch();
    }

    public void deleteByVersionAndGlobalIdAndCommitId(Long version, Long globalId, Long commitId) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)JV_SNAPSHOT).where(new Predicate[]{JaversSnapshotRepositoryImpl.JV_SNAPSHOT.version.eq((Object)version), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.eq((Object)globalId), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.commitFk.eq((Object)commitId)})).execute();
    }

    public void deleteByGlobalIds(List<Long> globalIds) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)JV_SNAPSHOT).where((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.in(globalIds))).execute();
    }

    public Long getCountByCommitId(Long commitId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.from((Expression)JV_SNAPSHOT)).where((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.commitFk.eq((Object)commitId))).fetchCount();
    }

    public void updateAsInitial(Long globalId) {
        Long minVersion = (Long)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.version.min()).from((Expression)JV_SNAPSHOT)).where((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.eq((Object)globalId))).fetchFirst();
        ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)JV_SNAPSHOT).set((Path)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.type, (Object)SnapshotType.INITIAL.name())).where(new Predicate[]{JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.eq((Object)globalId), JaversSnapshotRepositoryImpl.JV_SNAPSHOT.version.eq((Object)minVersion)})).execute();
    }

    private List<Long> getTerminalGlobalIds() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)Projections.constructor(Long.class, (Expression[])new Expression[]{JaversSnapshotRepositoryImpl.JV_SNAPSHOT.globalIdFk.as(GLOBAL_ID)})).from((Expression)JV_SNAPSHOT)).where((Predicate)JaversSnapshotRepositoryImpl.JV_SNAPSHOT.type.eq((Object)SnapshotType.TERMINAL.name()))).fetch();
    }
}

