/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Subscriber;
import org.qubership.atp.environments.model.Subscription;
import org.qubership.atp.environments.model.impl.SubscriptionImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ProjectRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SubscriberRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SubscriptionRepositoryImpl
extends AbstractRepository {
    public static final Integer CASCADE_SUSBSCRIPTION_TYPE = 22;
    private final SQLQueryFactory queryFactory;
    private final Provider<ProjectRepositoryImpl> projectRepo;
    private final Provider<EnvironmentRepositoryImpl> environmentRepo;
    private final Provider<SystemRepositoryImpl> systemRepo;
    private final Provider<SubscriberRepositoryImpl> subscriberRepo;
    private final Provider<SubscriptionRepositoryImpl> subscriptionRepo;
    private final SubscriptionProjection projection = new SubscriptionProjection(this);
    private final BooleanExpression cascadeSubscription;
    private final BooleanExpression simpleSubscription;

    @Autowired
    public SubscriptionRepositoryImpl(SQLQueryFactory queryFactory, Provider<ProjectRepositoryImpl> projectRepo, Provider<EnvironmentRepositoryImpl> environmentRepo, Provider<SystemRepositoryImpl> systemRepo, Provider<SubscriberRepositoryImpl> subscriberRepo, Provider<SubscriptionRepositoryImpl> subscriptionRepo) {
        this.cascadeSubscription = SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriptionType.eq((Object)CASCADE_SUSBSCRIPTION_TYPE);
        this.simpleSubscription = SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriptionType.ne((Object)CASCADE_SUSBSCRIPTION_TYPE);
        this.queryFactory = queryFactory;
        this.projectRepo = projectRepo;
        this.environmentRepo = environmentRepo;
        this.systemRepo = systemRepo;
        this.subscriberRepo = subscriberRepo;
        this.subscriptionRepo = subscriptionRepo;
    }

    @Nullable
    public Subscription getById(@Nonnull UUID id) {
        return (Subscription)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public List<Subscription> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).fetch();
    }

    @Nonnull
    public List<Subscription> getAllByParentId(@Nonnull UUID subscriberId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId.eq((Object)subscriberId))).fetch();
    }

    @Nonnull
    public List<UUID> getListIdSubscriptionsForProject(@Nonnull UUID projectId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.projectId.eq((Object)projectId))).fetch();
    }

    @Nonnull
    public List<UUID> getListIdSubscriptionsForProject(@Nonnull UUID projectId, boolean cascade) {
        BooleanExpression condition = cascade ? this.cascadeSubscription : this.simpleSubscription;
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.projectId.eq((Object)projectId).and((Predicate)condition))).fetch();
    }

    @Nonnull
    public List<UUID> getListIdSubscriptionsForEnvironment(@Nonnull UUID environmentId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.environmentId.eq((Object)environmentId))).fetch();
    }

    @Nonnull
    public List<UUID> getListIdSubscriptionsForEnvironment(@Nonnull UUID environmentId, boolean cascade) {
        BooleanExpression condition = cascade ? this.cascadeSubscription : this.simpleSubscription;
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.environmentId.eq((Object)environmentId).and((Predicate)condition))).fetch();
    }

    @Nonnull
    public List<UUID> getListIdSubscriptionsForSystem(@Nonnull UUID systemId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.systemId.eq((Object)systemId))).fetch();
    }

    @Nonnull
    public List<UUID> getListIdSubscriptionsForSystem(@Nonnull UUID systemId, boolean cascade) {
        BooleanExpression condition = cascade ? this.cascadeSubscription : this.simpleSubscription;
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.systemId.eq((Object)systemId).and((Predicate)condition))).fetch();
    }

    @Nonnull
    public List<Subscription> getSubscriberSubscriptions(@Nonnull UUID subscriberId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId.eq((Object)subscriberId))).fetch();
    }

    @Nonnull
    public List<Subscription> getProjectSubscriptions(@Nonnull UUID projectId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.projectId.eq((Object)projectId))).fetch();
    }

    @Nonnull
    public List<Subscription> getEnvironmentSubscriptions(@Nonnull UUID environmentId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.environmentId.eq((Object)environmentId))).fetch();
    }

    @Nonnull
    public List<Subscription> getSystemSubscriptions(@Nonnull UUID systemId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.systemId.eq((Object)systemId))).fetch();
    }

    @Nonnull
    public List<UUID> getListSubscriptionsByConditions(UUID projectId, UUID environmentId, UUID systemId, @Nonnull UUID subscriberId) {
        List listSubscriptionId = projectId != null ? ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.projectId.eq((Object)projectId).and((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId.eq((Object)subscriberId)))).fetch() : (environmentId != null ? ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.environmentId.eq((Object)environmentId).and((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId.eq((Object)subscriberId)))).fetch() : ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id).from((Expression)SUBSCRIPTIONS)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.systemId.eq((Object)systemId).and((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId.eq((Object)subscriberId)))).fetch());
        return listSubscriptionId;
    }

    @Nonnull
    public Subscription create(Integer subscriptionType, UUID projectId, UUID environmentId, UUID systemId, UUID subscriberId, Integer status, Long lastUpdated) {
        Timestamp lastUpdatedTimestamp = new Timestamp(lastUpdated);
        UUID uuid = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)SUBSCRIPTIONS).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriptionType, (Object)subscriptionType)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.projectId, (Object)projectId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.environmentId, (Object)environmentId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.systemId, (Object)systemId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId, (Object)subscriberId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.status, (Object)status)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.lastUpdated, (Object)lastUpdatedTimestamp)).executeWithKey((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id);
        return this.projection.create(uuid, subscriptionType, projectId, environmentId, systemId, subscriberId, status, lastUpdatedTimestamp);
    }

    @Nonnull
    public Subscription update(@Nonnull UUID subscriptionId, Integer subscriptionType, UUID projectId, UUID environmentId, UUID systemId, UUID subscriberId, Integer status, Long lastUpdated) {
        Timestamp lastUpdatedTimestamp = new Timestamp(lastUpdated);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)SUBSCRIPTIONS).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriptionType, (Object)subscriptionType)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.projectId, (Object)projectId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.environmentId, (Object)environmentId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.systemId, (Object)systemId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.subscriberId, (Object)subscriberId)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.status, (Object)status)).set((Path)SubscriptionRepositoryImpl.SUBSCRIPTIONS.lastUpdated, (Object)lastUpdatedTimestamp)).where((Predicate)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id.eq((Object)subscriptionId))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Nothing updated");
        return this.projection.create(subscriptionId, subscriptionType, projectId, environmentId, systemId, subscriberId, status, lastUpdatedTimestamp);
    }

    public void delete(UUID subscriptionId) {
        this.deleteReferenceToTable(subscriptionId, (RelationalPathBase)SUBSCRIPTIONS, (SimplePath<UUID>)SubscriptionRepositoryImpl.SUBSCRIPTIONS.id);
    }

    private void deleteReferenceToTable(UUID id, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)id))).execute();
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class SubscriptionProjection
    extends MappingProjection<Subscription> {
        static final long serialVersionUID = 42L;
        private final transient SubscriptionRepositoryImpl repo;

        public SubscriptionProjection(SubscriptionRepositoryImpl repo) {
            super(Subscription.class, (Expression[])AbstractRepository.SUBSCRIPTIONS.all());
            this.repo = repo;
        }

        protected Subscription map(Tuple tuple) {
            UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.id);
            assert (uuid != null);
            Integer subscriptionType = (Integer)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.subscriptionType);
            UUID projectId = (UUID)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.projectId);
            UUID environmentId = (UUID)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.environmentId);
            UUID systemId = (UUID)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.systemId);
            UUID subscriberId = (UUID)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.subscriberId);
            Integer status = (Integer)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.status);
            Timestamp lastUpdated = (Timestamp)tuple.get((Expression)AbstractRepository.SUBSCRIPTIONS.lastUpdated);
            assert (lastUpdated != null);
            return this.create(uuid, subscriptionType, projectId, environmentId, systemId, subscriberId, status, lastUpdated);
        }

        protected SubscriptionImpl create(UUID uuid, Integer subscriptionType, UUID projectId, UUID environmentId, UUID systemId, UUID subscriberId, Integer status, Timestamp lastUpdated) {
            Subscriber subscriberAsObj = Proxies.withId(Subscriber.class, subscriberId, id -> ((SubscriberRepositoryImpl)this.repo.subscriberRepo.get()).getById((UUID)id));
            return new SubscriptionImpl(uuid, subscriptionType, projectId, environmentId, systemId, subscriberAsObj, status, Long.valueOf(lastUpdated.getTime()), null);
        }
    }
}

