/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.ServerItf;
import org.qubership.atp.environments.model.System;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.impl.Context;
import org.qubership.atp.environments.model.impl.EnvironmentImpl;
import org.qubership.atp.environments.model.impl.SystemCategoryImpl;
import org.qubership.atp.environments.model.impl.SystemImpl;
import org.qubership.atp.environments.model.utils.enums.Status;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ContextRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.ProjectionRepository;
import org.qubership.atp.environments.repo.impl.SystemCategoryRepositoryImpl;
import org.qubership.atp.environments.repo.projections.FullSystemProjection;
import org.qubership.atp.environments.repo.projections.LazySystemProjection;
import org.qubership.atp.environments.repo.projections.ShortSystemProjection;
import org.qubership.atp.environments.repo.projections.SystemProjectionWithoutProxy;
import org.qubership.atp.environments.service.direct.KafkaService;
import org.qubership.atp.environments.service.rest.server.dto.EventType;
import org.qubership.atp.environments.versioning.service.CommitEntityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.support.NoOpCache;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public class SystemRepositoryImpl
extends AbstractRepository
implements ProjectionRepository<System> {
    private static final Logger log = LoggerFactory.getLogger(SystemRepositoryImpl.class);
    private static final Expression<?>[] COLUMNS;
    private final ContextRepository contextRepository;
    protected final SQLQueryFactory queryFactory;
    private final Provider<EnvironmentRepositoryImpl> environmentRepo;
    private final Provider<SystemCategoryRepositoryImpl> systemCategoryRepo;
    private final Provider<ConnectionRepositoryImpl> connectionRepo;
    private final CommitEntityService<System> commitSystemService;
    private final CommitEntityService<Environment> commitEnvironmentService;
    private final KafkaService kafkaService;
    private final FullSystemProjection projection = new FullSystemProjection(this);
    private final ShortSystemProjection shortSystemProjection = new ShortSystemProjection(this);
    private final ShortSystemProjection lazySystemProjection = new LazySystemProjection(this);
    private final SystemProjectionWithoutProxy systemProjectionWithoutProxy = new SystemProjectionWithoutProxy(this);
    private Gson gson = new Gson();
    private final Cache systemCachedMap;
    private final Cache systemsByEnvironmentIdCachedMap;

    @Autowired
    public SystemRepositoryImpl(SQLQueryFactory queryFactory, Provider<EnvironmentRepositoryImpl> environmentRepo, Provider<SystemCategoryRepositoryImpl> systemCategoryRepo, Provider<ConnectionRepositoryImpl> connectionRepo, CommitEntityService<System> commitSystemService, CommitEntityService<Environment> commitEnvironmentService, KafkaService kafkaService, CacheManager cacheManager, ContextRepository contextRepository) {
        this.queryFactory = queryFactory;
        this.environmentRepo = environmentRepo;
        this.systemCategoryRepo = systemCategoryRepo;
        this.connectionRepo = connectionRepo;
        this.commitSystemService = commitSystemService;
        this.commitEnvironmentService = commitEnvironmentService;
        this.kafkaService = kafkaService;
        this.systemCachedMap = cacheManager != null && cacheManager.getCache("ATP_ENVIRONMENTS-SYSTEM_VERSION") != null ? cacheManager.getCache("ATP_ENVIRONMENTS-SYSTEM_VERSION") : new NoOpCache("ATP_ENVIRONMENTS-SYSTEM_VERSION");
        this.systemsByEnvironmentIdCachedMap = cacheManager != null && cacheManager.getCache("ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID") != null ? cacheManager.getCache("ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID") : new NoOpCache("ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID");
        this.contextRepository = contextRepository;
    }

    public Provider<EnvironmentRepositoryImpl> getEnvironmentRepo() {
        return this.environmentRepo;
    }

    public Provider<SystemCategoryRepositoryImpl> getSystemCategoryRepo() {
        return this.systemCategoryRepo;
    }

    public Provider<ConnectionRepositoryImpl> getConnectionRepo() {
        return this.connectionRepo;
    }

    @Nullable
    public System getById(@Nonnull UUID id) {
        return (System)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).fetchOne();
    }

    @Nullable
    public System getShortById(UUID id) {
        return (System)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortSystemProjection).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).fetchOne();
    }

    public boolean existsById(@Nonnull UUID id) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortSystemProjection).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).fetchCount() > 0L;
    }

    @Nonnull
    public UUID getProjectId(@Nonnull UUID systemId) {
        log.info("Get projectId for system with id '{}'", (Object)systemId);
        return (UUID)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct((Expression)SystemRepositoryImpl.ENVIRONMENTS.projectId).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)SystemRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)systemId))).fetchOne();
    }

    @Nullable
    public System getByIdV2(@Nonnull UUID id) {
        Iterator<System> iterator = this.getSystems((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id)).values().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public List<System> getSystemsByProjectId(UUID projectId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct(this.resolveProjection()).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)SystemRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)SystemRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId))).fetch();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private Map<UUID, System> getSystems(Predicate predicate) {
        SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(COLUMNS).from((Expression)SYSTEMS)).leftJoin((EntityPath)SYSTEM_CATEGORIES)).on((Predicate)SystemRepositoryImpl.SYSTEMS.categoryId.eq((Expression)SystemRepositoryImpl.SYSTEM_CATEGORIES.id))).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)SystemRepositoryImpl.ENVIRONMENTS.id))).where(predicate);
        HashMap<UUID, System> systems = new HashMap<UUID, System>();
        HashMap<UUID, Environment> environments = new HashMap<UUID, Environment>();
        HashMap<UUID, SystemCategory> systemCategories = new HashMap<UUID, SystemCategory>();
        try (CloseableIterator iter = sqlQuery.iterate();){
            while (iter.hasNext()) {
                Tuple row = (Tuple)iter.next();
                UUID id = (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEMS.id);
                UUID envId = (UUID)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.id);
                UUID sysCatId = (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEM_CATEGORIES.id);
                System system = systems.computeIfAbsent(id, key -> this.projection.create(id, (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.name), (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.description), (Timestamp)row.get((Expression)SystemRepositoryImpl.SYSTEMS.created), (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEMS.createdBy), (Timestamp)row.get((Expression)SystemRepositoryImpl.SYSTEMS.modified), (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEMS.modifiedBy), null, (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.status), (Timestamp)row.get((Expression)SystemRepositoryImpl.SYSTEMS.dateOfLastCheck), (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.version), (Timestamp)row.get((Expression)SystemRepositoryImpl.SYSTEMS.dateOfCheckVersion), (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.parametersGettingVersion), (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEMS.parentSystemId), new ArrayList<Environment>(), (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.serverItf), (Boolean)row.get((Expression)SystemRepositoryImpl.SYSTEMS.mergeByName), (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEMS.linkToSystemId), (UUID)row.get((Expression)SystemRepositoryImpl.SYSTEMS.externalId), null, (String)row.get((Expression)SystemRepositoryImpl.SYSTEMS.externalName)));
                if (envId != null) {
                    Environment environment = environments.computeIfAbsent(envId, key -> new EnvironmentImpl(key, (String)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.name), (String)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.graylogName), (String)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.description), (String)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.ssmSolutionAlias), (String)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.ssmInstanceAlias), (String)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.consulEgressConfigPath), Long.valueOf(((Timestamp)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.created)).getTime()), (UUID)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.createdBy), row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.modified) != null ? Long.valueOf(((Timestamp)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.modified)).getTime()) : null, (UUID)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.modifiedBy), (UUID)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.projectId), null, (UUID)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.categoryId), (UUID)row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.sourceId), row.get((Expression)SystemRepositoryImpl.ENVIRONMENTS.tags)));
                    system.getEnvironments().add(environment);
                }
                if (sysCatId == null) continue;
                SystemCategory systemCategory = systemCategories.computeIfAbsent(sysCatId, key -> new SystemCategoryImpl(key, (String)row.get((Expression)SystemRepositoryImpl.SYSTEM_CATEGORIES.name), (String)row.get((Expression)SystemRepositoryImpl.SYSTEM_CATEGORIES.description), Long.valueOf(((Timestamp)row.get((Expression)SystemRepositoryImpl.SYSTEM_CATEGORIES.created)).getTime()), null));
                system.setSystemCategory(systemCategory);
            }
        }
        return systems;
    }

    @Nonnull
    public List<System> getAll() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).orderBy(SystemRepositoryImpl.SYSTEMS.name.asc())).fetch();
    }

    @Nonnull
    @Cacheable(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#environmentId", condition="#environmentId!=null")
    public List<System> getAllByParentId(@Nonnull UUID environmentId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.systemProjectionWithoutProxy).from((Expression)SYSTEMS)).where((Predicate)this.systemsUnder(environmentId))).orderBy(SystemRepositoryImpl.SYSTEMS.name.asc())).fetch();
    }

    @Nonnull
    public List<System> getAllByParentId(@Nonnull UUID environmentId, String systemType) {
        UUID categoryId = ((SystemCategoryRepositoryImpl)this.systemCategoryRepo.get()).getByName(systemType).getId();
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).where((Predicate)this.systemsUnder(environmentId).and((Predicate)SystemRepositoryImpl.SYSTEMS.categoryId.eq((Object)categoryId)))).orderBy(SystemRepositoryImpl.SYSTEMS.name.asc())).fetch();
    }

    public List<System> getAllByParentIdAndCategoryId(@Nonnull UUID environmentId, @Nonnull UUID categoryId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).where((Predicate)this.systemsUnder(environmentId).and((Predicate)SystemRepositoryImpl.SYSTEMS.categoryId.eq((Object)categoryId)))).orderBy(SystemRepositoryImpl.SYSTEMS.name.asc())).fetch();
    }

    @Nonnull
    public List<System> getAllShortByParentId(@Nonnull UUID environmentId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.shortSystemProjection).from((Expression)SYSTEMS)).where((Predicate)this.systemsUnder(environmentId))).orderBy(SystemRepositoryImpl.SYSTEMS.name.asc())).fetch();
    }

    @Nonnull
    public List<String> getSystemNamesByProjectId(@Nonnull UUID projectId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct((Expression)SystemRepositoryImpl.SYSTEMS.name).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.in((SubQueryExpression)((SQLQuery)new SQLQuery().select((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.in((SubQueryExpression)((SQLQuery)new SQLQuery().select((Expression)SystemRepositoryImpl.ENVIRONMENTS.id).from((Expression)ENVIRONMENTS)).where((Predicate)SystemRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId))))))).orderBy(SystemRepositoryImpl.SYSTEMS.name.asc())).fetch();
    }

    @Nonnull
    public List<Tuple> checkSystemNameIsUniqueUnderEnvironment(@Nonnull UUID environmentId, String systemName) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{SystemRepositoryImpl.SYSTEMS.name, SystemRepositoryImpl.SYSTEMS.id}).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)SystemRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)SystemRepositoryImpl.ENVIRONMENTS.id.eq((Object)environmentId).and((Predicate)SystemRepositoryImpl.SYSTEMS.name.eq((Object)systemName)))).fetch();
    }

    @Nonnull
    public List<Tuple> checkSystemNameIsUniqueUnderEnvironments(@Nonnull List<UUID> environmentIds, String systemName) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{SystemRepositoryImpl.SYSTEMS.name, SystemRepositoryImpl.SYSTEMS.id}).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)SystemRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)SystemRepositoryImpl.ENVIRONMENTS.id.in(environmentIds).and((Predicate)SystemRepositoryImpl.SYSTEMS.name.eq((Object)systemName)))).fetch();
    }

    private BooleanExpression systemsUnder(@Nonnull UUID environmentId) {
        return SystemRepositoryImpl.SYSTEMS.id.in((SubQueryExpression)((SQLQuery)new SQLQuery().select((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId)));
    }

    @Nonnull
    public Collection<System> getAllByParentIdV2(@Nonnull UUID environmentId) {
        log.info("Get systems for environment with id '{}'", (Object)environmentId);
        return this.getSystems((Predicate)this.systemsUnder(environmentId)).values();
    }

    @Nonnull
    public Collection<System> getAllByParentIdV2(@Nonnull UUID environmentId, String systemType) {
        log.info("Get systems for environment with id '{}' and type '{}'", (Object)environmentId, (Object)systemType);
        UUID categoryId = ((SystemCategoryRepositoryImpl)this.systemCategoryRepo.get()).getByName(systemType).getId();
        log.info("Get systems for environment with id '{}' and category with id '{}'", (Object)environmentId, (Object)categoryId);
        return this.getSystems((Predicate)this.systemsUnder(environmentId).and((Predicate)SystemRepositoryImpl.SYSTEMS.categoryId.eq((Object)categoryId))).values();
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#environmentId", condition="#environmentId!=null")
    public System create(@Nonnull UUID environmentId, @Nonnull String name, String description, Long created, UUID createdBy, UUID systemCategoryId, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, String externalName) {
        Timestamp createdTimestamp = new Timestamp(created);
        String parameters = parametersGettingVersion != null ? this.gson.toJson((Object)parametersGettingVersion) : null;
        String parametersToItf = serverItf != null ? this.gson.toJson((Object)serverItf) : null;
        UUID uuid = (UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)SYSTEMS).set((Path)SystemRepositoryImpl.SYSTEMS.name, (Object)name)).set((Path)SystemRepositoryImpl.SYSTEMS.description, (Object)description)).set((Path)SystemRepositoryImpl.SYSTEMS.created, (Object)createdTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.createdBy, (Object)createdBy)).set((Path)SystemRepositoryImpl.SYSTEMS.modified, (Object)createdTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.modifiedBy, (Object)createdBy)).set((Path)SystemRepositoryImpl.SYSTEMS.categoryId, (Object)systemCategoryId)).set((Path)SystemRepositoryImpl.SYSTEMS.parametersGettingVersion, (Object)parameters)).set((Path)SystemRepositoryImpl.SYSTEMS.parentSystemId, (Object)parentSystemId)).set((Path)SystemRepositoryImpl.SYSTEMS.serverItf, (Object)parametersToItf)).set((Path)SystemRepositoryImpl.SYSTEMS.mergeByName, (Object)mergeByName)).set((Path)SystemRepositoryImpl.SYSTEMS.linkToSystemId, (Object)linkToSystemId)).set((Path)SystemRepositoryImpl.SYSTEMS.externalId, (Object)externalId)).set((Path)SystemRepositoryImpl.SYSTEMS.externalName, (Object)externalName)).executeWithKey((Path)SystemRepositoryImpl.SYSTEMS.id);
        ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ENVIRONMENT_SYSTEMS).set((Path)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId, (Object)environmentId)).set((Path)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId, (Object)uuid)).execute();
        ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(environmentId, createdTimestamp, createdBy, null);
        SystemImpl system = this.projection.create(uuid, name, description, createdTimestamp, createdBy, createdTimestamp, createdBy, systemCategoryId, null, null, null, null, parameters, parentSystemId, parametersToItf, mergeByName, linkToSystemId, externalId, null, externalName, null);
        this.commitSystemService.commit((System)system);
        this.commitEnvironmentService.commit(system.getEnvironments());
        return system;
    }

    @CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#environmentId", condition="#environmentId!=null")
    public System create(@Nonnull UUID environmentId, @Nonnull UUID systemId, @Nonnull String name, String description, Long created, UUID createdBy, UUID systemCategoryId, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName) {
        Timestamp createdTimestamp = new Timestamp(created);
        String parameters = parametersGettingVersion != null ? this.gson.toJson((Object)parametersGettingVersion) : null;
        String parametersToItf = serverItf != null ? this.gson.toJson((Object)serverItf) : null;
        ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)SYSTEMS).set((Path)SystemRepositoryImpl.SYSTEMS.name, (Object)name)).set((Path)SystemRepositoryImpl.SYSTEMS.description, (Object)description)).set((Path)SystemRepositoryImpl.SYSTEMS.created, (Object)createdTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.createdBy, (Object)createdBy)).set((Path)SystemRepositoryImpl.SYSTEMS.modified, (Object)createdTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.modifiedBy, (Object)createdBy)).set((Path)SystemRepositoryImpl.SYSTEMS.categoryId, (Object)systemCategoryId)).set((Path)SystemRepositoryImpl.SYSTEMS.parametersGettingVersion, (Object)parameters)).set((Path)SystemRepositoryImpl.SYSTEMS.parentSystemId, (Object)parentSystemId)).set((Path)SystemRepositoryImpl.SYSTEMS.serverItf, (Object)parametersToItf)).set((Path)SystemRepositoryImpl.SYSTEMS.mergeByName, (Object)mergeByName)).set((Path)SystemRepositoryImpl.SYSTEMS.id, (Object)systemId)).set((Path)SystemRepositoryImpl.SYSTEMS.linkToSystemId, (Object)linkToSystemId)).set((Path)SystemRepositoryImpl.SYSTEMS.externalId, (Object)externalId)).set((Path)SystemRepositoryImpl.SYSTEMS.sourceId, (Object)sourceId)).set((Path)SystemRepositoryImpl.SYSTEMS.externalName, (Object)externalName)).execute();
        ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ENVIRONMENT_SYSTEMS).set((Path)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId, (Object)environmentId)).set((Path)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId, (Object)systemId)).execute();
        ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(environmentId, createdTimestamp, createdBy, null);
        SystemImpl system = this.projection.create(systemId, name, description, createdTimestamp, createdBy, createdTimestamp, createdBy, systemCategoryId, null, null, null, null, parameters, parentSystemId, parametersToItf, mergeByName, linkToSystemId, externalId, sourceId, externalName, null);
        this.commitSystemService.commit((System)system);
        this.commitEnvironmentService.commit(system.getEnvironments());
        return system;
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#targetEnvironment.getId()", condition="#targetEnvironment.getId()!=null")
    public System share(@Nonnull UUID systemId, @Nonnull Environment targetEnvironment, Long modified, UUID modifiedBy) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        this.updateSystemsModified(systemId, modifiedTimestamp, modifiedBy, false, null);
        ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)ENVIRONMENT_SYSTEMS).set((Path)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId, (Object)systemId)).set((Path)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId, (Object)targetEnvironment.getId())).execute();
        System system = (System)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)systemId))).fetchOne();
        ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(targetEnvironment.getId(), modifiedTimestamp, modifiedBy, null);
        this.commitSystemService.commit(system);
        this.commitEnvironmentService.commit(targetEnvironment);
        return system;
    }

    @Nonnull
    @CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#environmentId", condition="#environmentId!=null")
    public System unShare(@Nonnull UUID systemId, @Nonnull UUID environmentId, Long modified, UUID modifiedBy) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        this.updateSystemsModified(systemId, modifiedTimestamp, modifiedBy, false, null);
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)ENVIRONMENT_SYSTEMS).where((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId).and((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Object)systemId)))).execute();
        ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(environmentId, modifiedTimestamp, modifiedBy, null);
        log.info("Shared system id='{}' has been deleted from environment id='{}'", (Object)systemId, (Object)environmentId);
        return (System)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)systemId))).fetchOne();
    }

    @Nonnull
    public void updateSystemCategory(@Nonnull UUID id, UUID systemCategoryId, Long modified, UUID modifiedBy) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)SYSTEMS).set((Path)SystemRepositoryImpl.SYSTEMS.categoryId, (Object)systemCategoryId)).set((Path)SystemRepositoryImpl.SYSTEMS.modified, (Object)modifiedTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.modifiedBy, (Object)modifiedBy)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).execute();
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Information about system category not updated");
        List<Environment> environments = ((EnvironmentRepositoryImpl)this.environmentRepo.get()).getAllBySystemId(id);
        if (!CollectionUtils.isEmpty(environments)) {
            environments.forEach(environment -> {
                this.systemsByEnvironmentIdCachedMap.evictIfPresent((Object)environment.getId());
                ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(environment.getId(), modifiedTimestamp, modifiedBy, environment.getProjectId());
            });
            this.kafkaService.sendSystemKafkaNotification(id, EventType.UPDATE, environments.get(0).getProjectId());
        }
        this.commitSystemService.commit(Proxies.withId(System.class, id, this::getById));
    }

    @Nonnull
    @CachePut(value={"ATP_ENVIRONMENTS-SYSTEM_VERSION"}, key="#id", condition="#useProxy && @systemCachedMap.get(#id) != null")
    @CacheEvict(value={"ATP_ENVIRONMENTS-CONNECTIONS"}, key="#id", condition="#id!=null")
    public System update(@Nonnull UUID id, @Nonnull String name, String description, Long modified, UUID modifiedBy, UUID systemCategoryId, Status status, Long dateOfLastCheck, String version, Long dateOfCheckVersion, ParametersGettingVersion parametersGettingVersion, UUID parentSystemId, ServerItf serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, String externalName, boolean useProxy, boolean sendKafkaUpdate) {
        Timestamp modifiedTimestamp = new Timestamp(modified);
        Timestamp dateOfLastCheckTimestamp = dateOfLastCheck != null ? new Timestamp(dateOfLastCheck) : null;
        Timestamp dateOfCheckVersionTimestamp = dateOfCheckVersion != null ? new Timestamp(dateOfCheckVersion) : null;
        String parameters = parametersGettingVersion != null ? this.gson.toJson((Object)parametersGettingVersion) : null;
        String parametersToItf = serverItf != null ? this.gson.toJson((Object)serverItf) : null;
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)SYSTEMS).set((Path)SystemRepositoryImpl.SYSTEMS.name, (Object)name)).set((Path)SystemRepositoryImpl.SYSTEMS.description, (Object)description)).set((Path)SystemRepositoryImpl.SYSTEMS.modified, (Object)modifiedTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.modifiedBy, (Object)modifiedBy)).set((Path)SystemRepositoryImpl.SYSTEMS.categoryId, (Object)systemCategoryId)).set((Path)SystemRepositoryImpl.SYSTEMS.status, (Object)status.toString())).set((Path)SystemRepositoryImpl.SYSTEMS.dateOfLastCheck, (Object)dateOfLastCheckTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.version, (Object)version)).set((Path)SystemRepositoryImpl.SYSTEMS.dateOfCheckVersion, (Object)dateOfCheckVersionTimestamp)).set((Path)SystemRepositoryImpl.SYSTEMS.parametersGettingVersion, (Object)parameters)).set((Path)SystemRepositoryImpl.SYSTEMS.parentSystemId, (Object)parentSystemId)).set((Path)SystemRepositoryImpl.SYSTEMS.serverItf, (Object)parametersToItf)).set((Path)SystemRepositoryImpl.SYSTEMS.mergeByName, (Object)mergeByName)).set((Path)SystemRepositoryImpl.SYSTEMS.linkToSystemId, (Object)linkToSystemId)).set((Path)SystemRepositoryImpl.SYSTEMS.externalId, (Object)externalId)).set((Path)SystemRepositoryImpl.SYSTEMS.externalName, (Object)externalName)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).execute();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{SystemRepositoryImpl.SYSTEMS.created, SystemRepositoryImpl.SYSTEMS.createdBy, SystemRepositoryImpl.SYSTEMS.sourceId}).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).fetchOne();
        Timestamp created = (Timestamp)tuple.get((Expression)SystemRepositoryImpl.SYSTEMS.created);
        UUID createdBy = (UUID)tuple.get((Expression)SystemRepositoryImpl.SYSTEMS.createdBy);
        UUID sourceId = (UUID)tuple.get((Expression)SystemRepositoryImpl.SYSTEMS.sourceId);
        Preconditions.checkArgument((update > 0L ? 1 : 0) != 0, (Object)"Information about system not updated");
        List<Environment> environments = ((EnvironmentRepositoryImpl)this.environmentRepo.get()).getAllBySystemId(id);
        if (sendKafkaUpdate && !CollectionUtils.isEmpty(environments)) {
            this.kafkaService.sendSystemKafkaNotification(id, EventType.UPDATE, environments.get(0).getProjectId());
            environments.forEach(environment -> {
                this.systemsByEnvironmentIdCachedMap.evictIfPresent((Object)environment.getId());
                ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(environment.getId(), modifiedTimestamp, modifiedBy, environment.getProjectId());
            });
        }
        SystemImpl system = useProxy && this.systemCachedMap.get((Object)id) == null ? this.projection.create(id, name, description, created, createdBy, modifiedTimestamp, modifiedBy, systemCategoryId, status.toString(), dateOfLastCheckTimestamp, version, dateOfCheckVersionTimestamp, parameters, parentSystemId, parametersToItf, mergeByName, linkToSystemId, externalId, sourceId, externalName, environments) : this.projection.createWithoutProxy(id, name, description, created, createdBy, modifiedTimestamp, modifiedBy, systemCategoryId, status.toString(), dateOfLastCheckTimestamp, version, dateOfCheckVersionTimestamp, parameters, parentSystemId, parametersToItf, mergeByName, linkToSystemId, externalId, sourceId, externalName, environments);
        this.commitSystemService.commit((System)system);
        return system;
    }

    @Caching(evict={@CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEM_VERSION", "ATP_ENVIRONMENTS-CONNECTIONS", "ATP_ENVIRONMENTS-ENVIRONMENTS_BY_SYSTEM_ID"}, key="#id", condition="#id!=null && #environmentId!=null"), @CacheEvict(value={"ATP_ENVIRONMENTS-SYSTEMS_BY_ENVIRONMENT_ID"}, key="#environmentId", condition="#environmentId!=null")})
    public void delete(UUID id, UUID environmentId, Long modified, UUID modifiedBy, boolean sendKafkaUpdateEnvironmentEvent) {
        long usageCount;
        Timestamp modifiedTimestamp = new Timestamp(modified);
        if (sendKafkaUpdateEnvironmentEvent) {
            ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified(environmentId, modifiedTimestamp, modifiedBy, null);
        }
        if ((usageCount = ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId).from((Expression)ENVIRONMENT_SYSTEMS)).where((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Object)id))).fetchCount()) == 1L) {
            this.deleteReferenceToSystem(id, (RelationalPathBase)SYSTEMS, (SimplePath<UUID>)SystemRepositoryImpl.SYSTEMS.id);
            this.commitSystemService.delete(id);
            this.kafkaService.sendSystemKafkaNotification(id, EventType.DELETE, ((EnvironmentRepositoryImpl)this.environmentRepo.get()).getProjectId(environmentId));
        } else {
            ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)ENVIRONMENT_SYSTEMS).where((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId.eq((Object)id).and((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId)))).execute();
            this.commitSystemService.commit(Proxies.withId(System.class, id, this::getById));
        }
        this.commitEnvironmentService.commit(Proxies.withId(Environment.class, environmentId, envId -> ((EnvironmentRepositoryImpl)this.environmentRepo.get()).getById((UUID)envId)));
    }

    public void updateSystemsModified(@Nonnull UUID id, Timestamp modified, UUID modifiedBy, boolean sendKafkaNotification, UUID projectId) {
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)SYSTEMS).set((Path)SystemRepositoryImpl.SYSTEMS.modified, (Object)modified)).set((Path)SystemRepositoryImpl.SYSTEMS.modifiedBy, (Object)modifiedBy)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Object)id))).execute();
        if (sendKafkaNotification) {
            this.kafkaService.sendSystemKafkaNotification(id, EventType.UPDATE, projectId);
        }
    }

    public void updateSystemsModified(@Nonnull UUID id, Timestamp modified, UUID modifiedBy, List<Environment> environments) {
        Consumer<Environment> consumer = environment -> {
            this.systemsByEnvironmentIdCachedMap.evictIfPresent((Object)environment.getId());
            ((EnvironmentRepositoryImpl)this.environmentRepo.get()).updateEnvironmentsModified((Environment)environment, modified, modifiedBy);
        };
        if (!CollectionUtils.isEmpty(environments)) {
            this.updateSystemsModified(id, modified, modifiedBy, true, environments.get(0).getProjectId());
            environments.forEach(consumer);
        } else {
            ((EnvironmentRepositoryImpl)this.environmentRepo.get()).getAllBySystemId(id).forEach(consumer);
        }
    }

    private void deleteReferenceToSystem(UUID id, RelationalPathBase path, SimplePath<UUID> simplePath) {
        ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)path).where((Predicate)simplePath.eq((Object)id))).execute();
    }

    public List<System> getByListIds(List<UUID> systems) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.in(systems))).fetch();
    }

    public List<System> getByLinkToSystemId(UUID linkToSystemId) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.linkToSystemId.eq((Object)linkToSystemId))).fetch();
    }

    public System getBySourceId(UUID sourceId) {
        return (System)((SQLQuery)((SQLQuery)this.queryFactory.select(this.resolveProjection()).from((Expression)SYSTEMS)).where((Predicate)SystemRepositoryImpl.SYSTEMS.sourceId.eq((Object)sourceId))).fetchFirst();
    }

    public List<System> getSystemsByIdsAndProjectId(List<UUID> systemIds, UUID projectId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct(this.resolveProjection()).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).leftJoin((EntityPath)ENVIRONMENTS)).on((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Expression)SystemRepositoryImpl.ENVIRONMENTS.id))).where((Predicate)SystemRepositoryImpl.SYSTEMS.id.in(systemIds).and((Predicate)SystemRepositoryImpl.ENVIRONMENTS.projectId.eq((Object)projectId)))).fetch();
    }

    public System getSystemByNameAndEnvironmentId(String name, UUID environmentId) {
        return (System)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.selectDistinct(this.resolveProjection()).from((Expression)SYSTEMS)).leftJoin((EntityPath)ENVIRONMENT_SYSTEMS)).on((Predicate)SystemRepositoryImpl.SYSTEMS.id.eq((Expression)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.systemId))).where((Predicate)SystemRepositoryImpl.SYSTEMS.name.eq((Object)name.trim()).and((Predicate)SystemRepositoryImpl.ENVIRONMENT_SYSTEMS.environmentId.eq((Object)environmentId)))).fetchOne();
    }

    @Override
    public Context getContext() {
        return this.contextRepository.getContext();
    }

    @Override
    public MappingProjection<System> getFullProjection() {
        return this.projection;
    }

    @Override
    public MappingProjection<System> getLazyProjection() {
        return this.lazySystemProjection;
    }

    @Override
    public MappingProjection<System> getShortProjection() {
        return this.shortSystemProjection;
    }

    static {
        ImmutableList expressions = ImmutableList.builder().add((Object[])SYSTEMS.all()).add((Object[])SYSTEM_CATEGORIES.all()).add((Object[])ENVIRONMENTS.all()).build();
        COLUMNS = (Expression[])expressions.toArray((Object[])new Expression[0]);
    }
}

