/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.projections;

import com.google.gson.Gson;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.environments.db.Proxies;
import org.qubership.atp.environments.model.Connection;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.ParametersGettingVersion;
import org.qubership.atp.environments.model.ServerItf;
import org.qubership.atp.environments.model.SystemCategory;
import org.qubership.atp.environments.model.impl.SystemImpl;
import org.qubership.atp.environments.model.utils.enums.Status;
import org.qubership.atp.environments.repo.impl.ConnectionRepositoryImpl;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemCategoryRepositoryImpl;
import org.qubership.atp.environments.repo.impl.SystemRepositoryImpl;
import org.qubership.atp.environments.repo.projections.ShortSystemProjection;

public class LazySystemProjection
extends ShortSystemProjection {
    private static final long serialVersionUID = 42L;

    public LazySystemProjection(SystemRepositoryImpl repo) {
        super(repo);
    }

    public SystemImpl createWithoutProxy(UUID uuid, String name, String description, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nullable UUID systemCategoryId, String status, Timestamp dateOfLastCheck, String version, Timestamp dateOfCheckVersion, String parametersGettingVersion, @Nullable UUID parentSystemId, String serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName, List<Environment> environments) {
        SystemCategory systemCategory = null;
        if (systemCategoryId != null) {
            systemCategory = ((SystemCategoryRepositoryImpl)this.repo.getSystemCategoryRepo().get()).getById(systemCategoryId);
        }
        List<Connection> connectionsListId = ((ConnectionRepositoryImpl)this.repo.getConnectionRepo().get()).getAllShortByParentId(uuid);
        Status systemStatus = status == null ? Status.NOTHING : Status.valueOf((String)status);
        return new SystemImpl(uuid, name, description, Long.valueOf(created.getTime()), createdBy, modified == null ? null : Long.valueOf(modified.getTime()), modifiedBy, environments == null ? ((EnvironmentRepositoryImpl)this.repo.getEnvironmentRepo().get()).getAllBySystemId(uuid) : environments, systemCategory, connectionsListId, systemStatus, dateOfLastCheck == null ? null : Long.valueOf(dateOfLastCheck.getTime()), version, dateOfCheckVersion == null ? null : Long.valueOf(dateOfCheckVersion.getTime()), (ParametersGettingVersion)new Gson().fromJson(parametersGettingVersion, ParametersGettingVersion.class), parentSystemId, (ServerItf)new Gson().fromJson(serverItf, ServerItf.class), mergeByName, linkToSystemId, externalId, sourceId, externalName);
    }

    @Override
    public SystemImpl create(UUID uuid, String name, String description, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nullable SystemCategory systemCategory, String status, Timestamp dateOfLastCheck, String version, Timestamp dateOfCheckVersion, String parametersGettingVersion, @Nullable UUID parentSystemId, @Nullable List<Environment> environments, String serverItf, Boolean mergeByName, UUID linkToSystemId, UUID externalId, UUID sourceId, String externalName) {
        if (environments == null) {
            environments = Proxies.list(() -> ((EnvironmentRepositoryImpl)this.repo.getEnvironmentRepo().get()).getAllShortBySystemId(uuid));
        }
        List connectionsListId = Proxies.list(() -> ((ConnectionRepositoryImpl)this.repo.getConnectionRepo().get()).getAllShortByParentId(uuid));
        Status systemStatus = status == null ? Status.NOTHING : Status.valueOf((String)status);
        return new SystemImpl(uuid, name, description, Long.valueOf(created.getTime()), createdBy, modified == null ? null : Long.valueOf(modified.getTime()), modifiedBy, environments, systemCategory, connectionsListId, systemStatus, dateOfLastCheck == null ? null : Long.valueOf(dateOfLastCheck.getTime()), version, dateOfCheckVersion == null ? null : Long.valueOf(dateOfCheckVersion.getTime()), (ParametersGettingVersion)this.gson.fromJson(parametersGettingVersion, ParametersGettingVersion.class), parentSystemId, (ServerItf)this.gson.fromJson(serverItf, ServerItf.class), mergeByName, linkToSystemId, externalId, sourceId, externalName);
    }
}

