/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.repo.projections;

import com.google.gson.Gson;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.environments.model.Environment;
import org.qubership.atp.environments.model.impl.EnvironmentImpl;
import org.qubership.atp.environments.repo.impl.AbstractRepository;
import org.qubership.atp.environments.repo.impl.EnvironmentRepositoryImpl;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class ShortEnvironmentProjection
extends MappingProjection<Environment> {
    private static final long serialVersionUID = 42L;
    protected final transient EnvironmentRepositoryImpl repo;

    public ShortEnvironmentProjection(EnvironmentRepositoryImpl repo) {
        super(Environment.class, (Expression[])AbstractRepository.ENVIRONMENTS.all());
        this.repo = repo;
    }

    protected Environment map(Tuple tuple) {
        UUID uuid = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.id);
        assert (uuid != null);
        String name = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.name);
        assert (name != null);
        String graylogName = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.graylogName);
        String description = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.description);
        String ssmSolutionAlias = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.ssmSolutionAlias);
        String ssmInstanceAlias = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.ssmInstanceAlias);
        String consulEgressConfigPath = (String)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.consulEgressConfigPath);
        UUID projectId = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.projectId);
        assert (projectId != null);
        Timestamp created = (Timestamp)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.created);
        UUID createdBy = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.createdBy);
        Timestamp modified = (Timestamp)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.modified);
        UUID modifiedBy = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.modifiedBy);
        UUID categoryId = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.categoryId);
        UUID sourceId = (UUID)tuple.get((Expression)AbstractRepository.ENVIRONMENTS.sourceId);
        Object tags = tuple.get((Expression)AbstractRepository.ENVIRONMENTS.tags);
        assert (categoryId != null);
        return this.create(uuid, name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, created, createdBy, modified, modifiedBy, projectId, categoryId, sourceId, tags == null ? Collections.emptyList() : (List)new Gson().fromJson(tags.toString(), List.class));
    }

    public EnvironmentImpl create(UUID uuid, String name, String graylogName, String description, String ssmSolutionAlias, String ssmInstanceAlias, String consulEgressConfigPath, Timestamp created, UUID createdBy, Timestamp modified, UUID modifiedBy, @Nonnull UUID projectId, @Nonnull UUID categoryId, UUID sourceId, List<String> tags) {
        return new EnvironmentImpl(uuid, name, graylogName, description, ssmSolutionAlias, ssmInstanceAlias, consulEgressConfigPath, Long.valueOf(created.getTime()), createdBy, modified == null ? null : Long.valueOf(modified.getTime()), modifiedBy, projectId, null, categoryId, sourceId, tags);
    }
}

